/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.model;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import net.sansa_stack.rdf.spark.model.JenaNodeOps;
import org.apache.commons.io.IOUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Node_ANY;
import org.apache.jena.graph.Node_Blank;
import org.apache.jena.graph.Node_Literal;
import org.apache.jena.graph.Node_URI;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.writer.NTriplesWriter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.mutable.StringBuilder;

public abstract class JenaNodeOps$class {
    public static Iterable fromNTriples(JenaNodeOps $this, String rdf, String baseIRI) {
        return JavaConversions$.MODULE$.asScalaIterator(RDFDataMgr.createIteratorTriples((InputStream)IOUtils.toInputStream((String)rdf), (Lang)Lang.NTRIPLES, (String)baseIRI)).toIterable();
    }

    public static String toNTriples(JenaNodeOps $this, Iterable triples) {
        StringWriter writer = new StringWriter();
        NTriplesWriter.write((Writer)writer, (Iterator)JavaConversions$.MODULE$.asJavaIterator(triples.iterator()));
        return writer.toString();
    }

    public static Triple makeTriple(JenaNodeOps $this, Node s, Node_URI p, Node o) {
        return Triple.create((Node)s, (Node)p, (Node)o);
    }

    /*
     * WARNING - void declaration
     */
    public static Tuple3 fromTriple(JenaNodeOps $this, Triple t) {
        void var3_3;
        Node s = t.getSubject();
        Node p = t.getPredicate();
        Node o = t.getObject();
        Node node = p;
        if (node instanceof Node_URI) {
            Node_URI node_URI = (Node_URI)node;
            Tuple3 tuple3 = new Tuple3((Object)s, (Object)node_URI, (Object)o);
            return tuple3;
        }
        throw new RuntimeException(new StringBuilder().append((Object)"fromTriple: predicate ").append((Object)var3_3.toString()).append((Object)" must be a URI").toString());
    }

    public static Object foldNode(JenaNodeOps $this, Node node, Function1 funURI, Function1 funBNode, Function1 funLiteral) {
        Node node2;
        block5: {
            Object object;
            block3: {
                block4: {
                    block2: {
                        node2 = node;
                        if (!(node2 instanceof Node_URI)) break block2;
                        Node_URI node_URI = (Node_URI)node2;
                        object = funURI.apply((Object)node_URI);
                        break block3;
                    }
                    if (!(node2 instanceof Node_Blank)) break block4;
                    Node_Blank node_Blank = (Node_Blank)node2;
                    object = funBNode.apply((Object)node_Blank);
                    break block3;
                }
                if (!(node2 instanceof Node_Literal)) break block5;
                Node_Literal node_Literal = (Node_Literal)node2;
                object = funLiteral.apply((Object)node_Literal);
            }
            return object;
        }
        throw new MatchError((Object)node2);
    }

    public static Node_URI makeUri(JenaNodeOps $this, String iriStr) {
        return (Node_URI)NodeFactory.createURI((String)iriStr);
    }

    public static String fromUri(JenaNodeOps $this, Node_URI node) {
        if (node.isURI()) {
            return node.getURI();
        }
        throw new RuntimeException(new StringBuilder().append((Object)"fromUri: ").append((Object)node).append((Object)" must be a URI").toString());
    }

    public static Node_Blank makeBNode(JenaNodeOps $this) {
        return (Node_Blank)NodeFactory.createBlankNode();
    }

    public static Node_Blank makeBNodeLabel(JenaNodeOps $this, String label) {
        return (Node_Blank)NodeFactory.createBlankNode((String)label);
    }

    public static String fromBNode(JenaNodeOps $this, Node_Blank bn) {
        if (bn.isBlank()) {
            return bn.getBlankNodeLabel();
        }
        throw new RuntimeException(new StringBuilder().append((Object)"fromBNode: ").append((Object)bn.toString()).append((Object)" must be a BNode").toString());
    }

    private static ThreadLocal mapper(JenaNodeOps $this) {
        return new ThreadLocal<TypeMapper>($this){

            public TypeMapper initialValue() {
                return TypeMapper.getInstance();
            }
        };
    }

    public static RDFDatatype jenaDatatype(JenaNodeOps $this, Node_URI datatype) {
        String iriString = $this.fromUri(datatype);
        return ((TypeMapper)JenaNodeOps$class.mapper($this).get()).getSafeTypeByName(iriString);
    }

    public static RDFDatatype __xsdString(JenaNodeOps $this) {
        return ((TypeMapper)JenaNodeOps$class.mapper($this).get()).getTypeByName("http://www.w3.org/2001/XMLSchema#string");
    }

    public static Node_URI __xsdStringURI(JenaNodeOps $this) {
        return $this.makeUri("http://www.w3.org/2001/XMLSchema#string");
    }

    public static Node_URI __rdfLangStringURI(JenaNodeOps $this) {
        return $this.makeUri("http://www.w3.org/1999/02/22-rdf-syntax-ns#langString");
    }

    public static Node_Literal makeLiteral(JenaNodeOps $this, String lexicalForm, Node_URI datatype) {
        Node_URI node_URI = datatype;
        Node_URI node_URI2 = $this.__xsdStringURI();
        return !(node_URI != null ? !node_URI.equals(node_URI2) : node_URI2 != null) ? (Node_Literal)NodeFactory.createLiteral((String)lexicalForm, null, null) : (Node_Literal)NodeFactory.createLiteral((String)lexicalForm, null, (RDFDatatype)$this.jenaDatatype(datatype));
    }

    public static Node_Literal makeLangTaggedLiteral(JenaNodeOps $this, String lexicalForm, String lang) {
        return (Node_Literal)NodeFactory.createLiteral((String)lexicalForm, (String)$this.fromLang(lang), null);
    }

    public static Tuple3 fromLiteral(JenaNodeOps $this, Node_Literal literal) {
        String lexicalForm = literal.getLiteralLexicalForm();
        String literalLanguage = literal.getLiteralLanguage();
        return literalLanguage == null || literalLanguage.isEmpty() ? new Tuple3((Object)lexicalForm, (Object)JenaNodeOps$class.getDatatype$1($this, literal), (Object)None$.MODULE$) : new Tuple3((Object)lexicalForm, (Object)$this.__rdfLangStringURI(), (Object)new Some((Object)$this.makeLang(literalLanguage)));
    }

    public static String makeLang(JenaNodeOps $this, String langString) {
        return langString;
    }

    public static String fromLang(JenaNodeOps $this, String lang) {
        return lang;
    }

    public static Node_ANY ANY(JenaNodeOps $this) {
        return (Node_ANY)Node.ANY;
    }

    public static Node toConcreteNodeMatch(JenaNodeOps $this, Node node) {
        return node;
    }

    public static Object foldNodeMatch(JenaNodeOps $this, Node nodeMatch, Function0 funANY, Function1 funConcrete) {
        Node node = nodeMatch;
        Node_ANY node_ANY = $this.ANY();
        return !(node != null ? !node.equals(node_ANY) : node_ANY != null) ? funANY.apply() : funConcrete.apply((Object)nodeMatch);
    }

    public static boolean matches(JenaNodeOps $this, Node node1, Node node2) {
        return node1.matches(node2);
    }

    private static final Node_URI getDatatype$1(JenaNodeOps $this, Node_Literal literal$1) {
        RDFDatatype typ = literal$1.getLiteralDatatype();
        return typ == null ? $this.__xsdStringURI() : $this.makeUri(typ.getURI());
    }

    public static void $init$(JenaNodeOps $this) {
    }
}

