/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.rdf.spark.model;

import net.sansa_stack.rdf.spark.model.GraphXGraphOps;
import net.sansa_stack.rdf.spark.model.RDFNodeOps;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeTriplet;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.PartitionStrategy;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.hashing.MurmurHash3$;

public abstract class GraphXGraphOps$class {
    public static Graph loadGraphFromNTriples(GraphXGraphOps $this, String file, String baseIRI) {
        RDD qual$1 = $this.sparkContext().textFile(file, $this.sparkContext().textFile$default$2());
        Serializable x$10 = new Serializable($this, baseIRI){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphXGraphOps $outer;
            private final String baseIRI$1;

            public final Iterator<Object> apply(Iterator<String> x0$1) {
                Iterator<String> iterator = x0$1;
                Iterator iterator2 = ((RDFNodeOps)((Object)this.$outer)).fromNTriples(iterator.mkString("\n"), this.baseIRI$1).iterator();
                return iterator2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.baseIRI$1 = baseIRI$1;
            }
        };
        boolean x$11 = qual$1.mapPartitions$default$2();
        return $this.makeGraph((RDD<Object>)qual$1.mapPartitions((Function1)x$10, x$11, $this.uriTag()));
    }

    public static void saveGraphToNTriples(GraphXGraphOps $this, Graph graph, String file) {
        RDD<Object> qual$2 = $this.toTripleRDD((Graph<Object, Object>)graph);
        Serializable x$12 = new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphXGraphOps $outer;

            public final Iterator<String> apply(Iterator<Object> x0$2) {
                Iterator<Object> iterator = x0$2;
                Iterator iterator2 = Predef$.MODULE$.refArrayOps((Object[])((RDFNodeOps)((Object)this.$outer)).toNTriples((Iterable<Object>)iterator.toIterable()).split("\n")).iterator();
                return iterator2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        boolean x$13 = qual$2.mapPartitions$default$2();
        qual$2.mapPartitions((Function1)x$12, x$13, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(file);
    }

    public static Graph loadGraphFromSequenceFile(GraphXGraphOps $this, String file) {
        return $this.loadGraphFromSequenceFile(new StringBuilder().append((Object)file).append((Object)".vertices").toString(), new StringBuilder().append((Object)file).append((Object)".edges").toString());
    }

    public static void saveGraphToSequenceFile(GraphXGraphOps $this, Graph graph, String file) {
        $this.saveGraphToSequenceFile((Graph<Object, Object>)graph, new StringBuilder().append((Object)file).append((Object)".vertices").toString(), new StringBuilder().append((Object)file).append((Object)".edges").toString());
    }

    public static Graph loadGraphFromSequenceFile(GraphXGraphOps $this, String vertexFile, String edgeFile) {
        RDD vertices = $this.sparkContext().objectFile(vertexFile, $this.sparkContext().objectFile$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
        RDD edges = $this.sparkContext().objectFile(edgeFile, $this.sparkContext().objectFile$default$2(), ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(vertices, edges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), $this.nodeTag(), $this.tripleTag());
    }

    public static void saveGraphToSequenceFile(GraphXGraphOps $this, Graph graph, String vertexFile, String edgeFile) {
        graph.vertices().saveAsObjectFile(vertexFile);
        graph.edges().saveAsObjectFile(edgeFile);
    }

    public static Graph makeGraph(GraphXGraphOps $this, Iterable triples) {
        RDD triplesRDD = $this.sparkContext().parallelize(triples.toSeq(), $this.sparkContext().parallelize$default$2(), $this.uriTag());
        return $this.makeGraph((RDD<Object>)triplesRDD);
    }

    public static Graph makeGraph(GraphXGraphOps $this, RDD triples) {
        RDD subjectMappedEdges;
        RDD spo = triples.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphXGraphOps $outer;

            public final Tuple2<Object, Tuple2<Object, Object>> apply(Object x0$3) {
                Some<Tuple3<Object, Object, Object>> some;
                block3: {
                    Object object;
                    block2: {
                        object = x0$3;
                        Option option = this.$outer.uriTag().unapply(object);
                        if (option.isEmpty()) break block2;
                        Object object2 = option.get();
                        some = this.$outer.Triple().unapply(object2);
                        if (!some.isEmpty()) break block3;
                    }
                    throw new MatchError(object);
                }
                Object s = ((Tuple3)some.get())._1();
                Object p = ((Tuple3)some.get())._2();
                Object o = ((Tuple3)some.get())._3();
                Tuple2 tuple2 = new Tuple2(s, (Object)new Tuple2(p, o));
                return tuple2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD vertexIDs = spo.flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphXGraphOps $outer;

            public final Seq<Object> apply(Tuple2<Object, Tuple2<Object, Object>> x0$4) {
                Tuple2<Object, Tuple2<Object, Object>> tuple2 = x0$4;
                if (tuple2 != null) {
                    Object s = tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    Option option = this.$outer.nodeTag().unapply(s);
                    if (!option.isEmpty() && option.get() instanceof Object && tuple22 != null) {
                        Option option2;
                        Object p = tuple22._1();
                        Object o = tuple22._2();
                        Option option3 = this.$outer.tripleTag().unapply(p);
                        if (!option3.isEmpty() && option3.get() instanceof Object && !(option2 = this.$outer.nodeTag().unapply(o)).isEmpty() && option2.get() instanceof Object) {
                            Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s, p, o}));
                            return seq;
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, $this.nodeTag()).zipWithUniqueId();
        RDD vertices = vertexIDs.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> v) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)v._2$mcJ$sp()), v._1());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD x$14 = spo;
        ClassTag<Object> x$15 = $this.nodeTag();
        ClassTag x$16 = ClassTag$.MODULE$.apply(Tuple2.class);
        RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$14);
        Object x$17 = null;
        RDD x$18 = subjectMappedEdges = RDD$.MODULE$.rddToPairRDDFunctions(x$14, x$15, x$16, null).join(vertexIDs).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphXGraphOps $outer;

            public final Tuple2<Object, Tuple2<Object, Object>> apply(Tuple2<Object, Tuple2<Tuple2<Object, Object>, Object>> x0$5) {
                Tuple2<Object, Tuple2<Tuple2<Object, Object>, Object>> tuple2 = x0$5;
                if (tuple2 != null) {
                    Object s = tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    Option option = this.$outer.nodeTag().unapply(s);
                    if (!option.isEmpty() && option.get() instanceof Object && tuple22 != null) {
                        Tuple2 tuple23 = (Tuple2)tuple22._1();
                        long sid = tuple22._2$mcJ$sp();
                        if (tuple23 != null) {
                            Option option2;
                            Object p = tuple23._1();
                            Object o = tuple23._2();
                            Option option3 = this.$outer.tripleTag().unapply(p);
                            if (!option3.isEmpty() && option3.get() instanceof Object && !(option2 = this.$outer.nodeTag().unapply(o)).isEmpty() && option2.get() instanceof Object) {
                                long l = sid;
                                Tuple2 tuple24 = new Tuple2(o, (Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)l), p));
                                return tuple24;
                            }
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag<Object> x$19 = $this.nodeTag();
        ClassTag x$20 = ClassTag$.MODULE$.apply(Tuple2.class);
        RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$18);
        Object x$21 = null;
        RDD subjectObjectMappedEdges = RDD$.MODULE$.rddToPairRDDFunctions(x$18, x$19, x$20, null).join(vertexIDs).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphXGraphOps $outer;

            public final Edge<Object> apply(Tuple2<Object, Tuple2<Tuple2<Object, Object>, Object>> x0$6) {
                Tuple2<Object, Tuple2<Tuple2<Object, Object>, Object>> tuple2 = x0$6;
                if (tuple2 != null) {
                    Object o = tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    Option option = this.$outer.nodeTag().unapply(o);
                    if (!option.isEmpty() && option.get() instanceof Object && tuple22 != null) {
                        Tuple2 tuple23 = (Tuple2)tuple22._1();
                        long oid = tuple22._2$mcJ$sp();
                        if (tuple23 != null) {
                            long sid = tuple23._1$mcJ$sp();
                            Object p = tuple23._2();
                            long l = sid;
                            Option option2 = this.$outer.tripleTag().unapply(p);
                            if (!option2.isEmpty() && option2.get() instanceof Object) {
                                long l2 = oid;
                                Edge edge = new Edge(l, l2, p);
                                return edge;
                            }
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Edge.class));
        RDD subjectVertexIds = subjectObjectMappedEdges.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, None$> apply(Edge<Object> x) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)x.srcId()), (Object)None$.MODULE$);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD objectVertexIds = subjectObjectMappedEdges.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, None$> apply(Edge<Object> x) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)x.dstId()), (Object)None$.MODULE$);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        Graph a = Graph$.MODULE$.apply(vertices, subjectObjectMappedEdges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), $this.nodeTag(), $this.tripleTag());
        return a;
    }

    public static Graph makeHashedVertexGraph(GraphXGraphOps $this, RDD triples) {
        RDD spo = triples.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphXGraphOps $outer;

            public final Tuple3<Object, Object, Object> apply(Object x0$7) {
                Some<Tuple3<Object, Object, Object>> some;
                block3: {
                    Object object;
                    block2: {
                        object = x0$7;
                        Option option = this.$outer.uriTag().unapply(object);
                        if (option.isEmpty()) break block2;
                        Object object2 = option.get();
                        some = this.$outer.Triple().unapply(object2);
                        if (!some.isEmpty()) break block3;
                    }
                    throw new MatchError(object);
                }
                Object s = ((Tuple3)some.get())._1();
                Object p = ((Tuple3)some.get())._2();
                Object o = ((Tuple3)some.get())._3();
                Tuple3 tuple3 = new Tuple3(s, p, o);
                return tuple3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        RDD vertices = spo.flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphXGraphOps $outer;

            public final TraversableOnce<Tuple2<Object, Object>> apply(Tuple3<Object, Object, Object> x0$8) {
                Tuple3<Object, Object, Object> tuple3 = x0$8;
                if (tuple3 != null) {
                    Option option;
                    Option option2;
                    Object s = tuple3._1();
                    Object p = tuple3._2();
                    Object o = tuple3._3();
                    Option option3 = this.$outer.nodeTag().unapply(s);
                    if (!option3.isEmpty() && option3.get() instanceof Object && !(option2 = this.$outer.tripleTag().unapply(p)).isEmpty() && option2.get() instanceof Object && !(option = this.$outer.nodeTag().unapply(o)).isEmpty() && option.get() instanceof Object) {
                        TraversableOnce traversableOnce = (TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)GraphXGraphOps$class.hash$1(this.$outer, s)), s), new Tuple2((Object)BoxesRunTime.boxToLong((long)GraphXGraphOps$class.hash$1(this.$outer, p)), p), new Tuple2((Object)BoxesRunTime.boxToLong((long)GraphXGraphOps$class.hash$1(this.$outer, o)), o)}));
                        return traversableOnce;
                    }
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD edges = spo.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphXGraphOps $outer;

            public final Edge<Object> apply(Tuple3<Object, Object, Object> x0$9) {
                Tuple3<Object, Object, Object> tuple3 = x0$9;
                if (tuple3 != null) {
                    Option option;
                    Option option2;
                    Object s = tuple3._1();
                    Object p = tuple3._2();
                    Object o = tuple3._3();
                    Option option3 = this.$outer.nodeTag().unapply(s);
                    if (!option3.isEmpty() && option3.get() instanceof Object && !(option2 = this.$outer.tripleTag().unapply(p)).isEmpty() && option2.get() instanceof Object && !(option = this.$outer.nodeTag().unapply(o)).isEmpty() && option.get() instanceof Object) {
                        Edge edge = new Edge(GraphXGraphOps$class.hash$1(this.$outer, s), GraphXGraphOps$class.hash$1(this.$outer, o), p);
                        return edge;
                    }
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(vertices, edges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), $this.nodeTag(), $this.tripleTag());
    }

    public static RDD toTripleRDD(GraphXGraphOps $this, Graph graph) {
        return graph.triplets().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphXGraphOps $outer;

            public final Object apply(EdgeTriplet<Object, Object> x0$10) {
                EdgeTriplet<Object, Object> edgeTriplet = x0$10;
                Object object = this.$outer.Triple().apply(edgeTriplet.srcAttr(), edgeTriplet.attr(), edgeTriplet.dstAttr());
                return object;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, $this.uriTag());
    }

    public static Iterable getTriples(GraphXGraphOps $this, Graph graph) {
        return $this.toTripleRDD((Graph<Object, Object>)graph).toLocalIterator().toIterable();
    }

    public static RDD getObjectsRDD(GraphXGraphOps $this, Graph graph, Object subject, Object predicate) {
        return $this.findGraph((Graph<Object, Object>)graph, ((RDFNodeOps)((Object)$this)).toConcreteNodeMatch(subject), ((RDFNodeOps)((Object)$this)).toConcreteNodeMatch(predicate), ((RDFNodeOps)((Object)$this)).ANY()).triplets().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Object apply(EdgeTriplet<Object, Object> x$1) {
                return x$1.dstAttr();
            }
        }, $this.nodeTag());
    }

    public static RDD getObjectsRDD(GraphXGraphOps $this, Graph graph, Object predicate) {
        return $this.findGraph((Graph<Object, Object>)graph, ((RDFNodeOps)((Object)$this)).ANY(), ((RDFNodeOps)((Object)$this)).toConcreteNodeMatch(predicate), ((RDFNodeOps)((Object)$this)).ANY()).triplets().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Object apply(EdgeTriplet<Object, Object> x$2) {
                return x$2.dstAttr();
            }
        }, $this.nodeTag());
    }

    public static RDD getPredicatesRDD(GraphXGraphOps $this, Graph graph, Object subject) {
        return $this.findGraph((Graph<Object, Object>)graph, ((RDFNodeOps)((Object)$this)).toConcreteNodeMatch(subject), ((RDFNodeOps)((Object)$this)).ANY(), ((RDFNodeOps)((Object)$this)).ANY()).triplets().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Object apply(EdgeTriplet<Object, Object> x$3) {
                return x$3.attr();
            }
        }, $this.tripleTag());
    }

    public static RDD getSubjectsRDD(GraphXGraphOps $this, Graph graph, Object predicate, Object obj) {
        return $this.findGraph((Graph<Object, Object>)graph, ((RDFNodeOps)((Object)$this)).ANY(), ((RDFNodeOps)((Object)$this)).toConcreteNodeMatch(predicate), ((RDFNodeOps)((Object)$this)).toConcreteNodeMatch(obj)).triplets().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Object apply(EdgeTriplet<Object, Object> x$4) {
                return x$4.srcAttr();
            }
        }, $this.nodeTag());
    }

    public static RDD getSubjectsRDD(GraphXGraphOps $this, Graph graph, Object predicate) {
        return $this.findGraph((Graph<Object, Object>)graph, ((RDFNodeOps)((Object)$this)).ANY(), ((RDFNodeOps)((Object)$this)).toConcreteNodeMatch(predicate), ((RDFNodeOps)((Object)$this)).ANY()).triplets().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Object apply(EdgeTriplet<Object, Object> x$5) {
                return x$5.srcAttr();
            }
        }, $this.nodeTag());
    }

    public static Graph findGraph(GraphXGraphOps $this, Graph graph, Object subject, Object predicate, Object objectt) {
        return graph.subgraph((Function1)new Serializable($this, subject, predicate, objectt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphXGraphOps $outer;
            private final Object subject$1;
            private final Object predicate$1;
            private final Object objectt$1;

            public final boolean apply(EdgeTriplet<Object, Object> triplet) {
                return ((RDFNodeOps)((Object)this.$outer)).matchNode(triplet.srcAttr(), this.subject$1) && ((RDFNodeOps)((Object)this.$outer)).matchNode(triplet.attr(), this.predicate$1) && ((RDFNodeOps)((Object)this.$outer)).matchNode(triplet.dstAttr(), this.objectt$1);
            }
            {
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subject$1 = subject$1;
                this.predicate$1 = var3_3;
                this.objectt$1 = var4_4;
            }
        }, (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$6, Object x$7) {
                return true;
            }
        });
    }

    public static Iterator find(GraphXGraphOps $this, Graph graph, Object subject, Object predicate, Object objectt) {
        return $this.toTripleRDD($this.findGraph((Graph<Object, Object>)graph, subject, predicate, objectt)).toLocalIterator();
    }

    public static Graph union(GraphXGraphOps $this, Seq graphs) {
        return (Graph)graphs.reduce((Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphXGraphOps $outer;

            public final Graph<Object, Object> apply(Graph<Object, Object> left, Graph<Object, Object> right) {
                Graph newGraph = Graph$.MODULE$.apply(left.vertices().union((RDD)right.vertices()), left.edges().union((RDD)right.edges()), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), this.$outer.nodeTag(), this.$outer.tripleTag());
                return newGraph.partitionBy((PartitionStrategy)PartitionStrategy.RandomVertexCut$.MODULE$).groupEdges((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(Object attr1, Object attr2) {
                        return attr1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static Graph intersection(GraphXGraphOps $this, Seq graphs) {
        return (Graph)graphs.reduce((Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphXGraphOps $outer;

            public final Graph<Object, Object> apply(Graph<Object, Object> left, Graph<Object, Object> right) {
                Graph newGraph = Graph$.MODULE$.apply(left.vertices().intersection((RDD)right.vertices()), left.edges().intersection((RDD)right.edges()), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), this.$outer.nodeTag(), this.$outer.tripleTag());
                return newGraph.partitionBy((PartitionStrategy)PartitionStrategy.RandomVertexCut$.MODULE$).groupEdges((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(Object attr1, Object attr2) {
                        return attr1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static Graph difference(GraphXGraphOps $this, Graph g1, Graph g2) {
        Set matchingTriplets = Predef$.MODULE$.refArrayOps((Object[])g1.triplets().intersection(g2.triplets()).collect()).toSet();
        return g1.subgraph((Function1)new Serializable($this, matchingTriplets){
            public static final long serialVersionUID = 0L;
            private final Set matchingTriplets$1;

            public final boolean apply(EdgeTriplet<Object, Object> triplet) {
                return this.matchingTriplets$1.contains(triplet);
            }
            {
                this.matchingTriplets$1 = matchingTriplets$1;
            }
        }, (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$8, Object x$9) {
                return true;
            }
        });
    }

    public static boolean isomorphism(GraphXGraphOps $this, Graph left, Graph right) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public static long graphSize(GraphXGraphOps $this, Graph g) {
        return Graph$.MODULE$.graphToGraphOps(g, $this.nodeTag(), $this.tripleTag()).numEdges();
    }

    public static final long hash$1(GraphXGraphOps $this, Object s) {
        return MurmurHash3$.MODULE$.stringHash(s.toString());
    }

    public static void $init$(GraphXGraphOps $this) {
    }
}

