/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.rdf.spring_jena;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.dice_research.rdf.spring_jena.Jena2SpringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class JenaModelHttpMessageConverter
extends AbstractHttpMessageConverter<Model> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JenaModelHttpMessageConverter.class);
    public static final Lang[] SUPPORTED_LANGS = new Lang[]{Lang.JSONLD, Lang.JSONLD10, Lang.JSONLD11, Lang.NQUADS, Lang.NTRIPLES, Lang.RDFJSON, Lang.RDFPROTO, Lang.RDFTHRIFT, Lang.RDFXML, Lang.TRIG, Lang.TRIX, Lang.TURTLE};
    protected Lang defaultLang;
    protected MediaType defaultMediaType;
    protected Map<MediaType, Lang> type2Lang;

    public JenaModelHttpMessageConverter(Lang defaultLang, Map<MediaType, Lang> type2Lang) {
        this(defaultLang, Jena2SpringUtils.contentType2MediaType(defaultLang.getContentType()), type2Lang);
    }

    public JenaModelHttpMessageConverter(Lang defaultLang, MediaType defaultMediaType, Map<MediaType, Lang> type2Lang) {
        super(StandardCharsets.UTF_8, (MediaType[])type2Lang.keySet().toArray(MediaType[]::new));
        this.defaultLang = defaultLang;
        this.defaultMediaType = defaultMediaType;
        this.type2Lang = type2Lang;
    }

    protected MediaType getDefaultContentType(Model t) throws IOException {
        return this.defaultMediaType;
    }

    protected boolean supports(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (Model.class.equals(clazz)) {
            return true;
        }
        return Stream.of(clazz.getInterfaces()).filter(c -> Model.class.equals(c)).findFirst().isPresent();
    }

    protected Model readInternal(Class<? extends Model> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        MediaType type = inputMessage.getHeaders().getContentType();
        Lang lang = null;
        if (type == null) {
            LOGGER.warn("Content-type not set for incoming message. I will use the default language {}.", (Object)this.defaultLang);
            lang = this.defaultLang;
        } else {
            if (type.getCharset() != null) {
                type = new MediaType(type.getType(), type.getSubtype());
            }
            if ((lang = this.type2Lang.get(type)) == null) {
                throw new HttpMessageNotReadableException("Unsupported content type " + type.toString(), inputMessage);
            }
        }
        Model result = ModelFactory.createDefaultModel();
        try {
            RDFDataMgr.read((Model)result, (InputStream)inputMessage.getBody(), (Lang)lang);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpMessageNotReadableException("Exception while parsing RDF data.", (Throwable)e, inputMessage);
        }
        return result;
    }

    protected void writeInternal(Model model, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        MediaType type = outputMessage.getHeaders().getContentType();
        Lang lang = null;
        if (type == null) {
            LOGGER.warn("Content-type not set for outgoing message. I will use the default language {}.", (Object)this.defaultLang);
            lang = this.defaultLang;
        } else {
            if (type.getCharset() != null) {
                type = new MediaType(type.getType(), type.getSubtype());
            }
            if ((lang = this.type2Lang.get(type)) == null) {
                throw new HttpMessageNotWritableException("Unsupported content type " + type.toString());
            }
        }
        try {
            RDFDataMgr.write((OutputStream)outputMessage.getBody(), (Model)model, (Lang)lang);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpMessageNotWritableException("Exception while writing RDF data.", (Throwable)e);
        }
    }

    public static JenaModelHttpMessageConverter create(Lang ... langs) {
        if (langs.length == 0) {
            throw new IllegalArgumentException("The converter class needs at least one valid serialization language.");
        }
        return JenaModelHttpMessageConverter.create(langs[0], langs);
    }

    public static JenaModelHttpMessageConverter create(Lang defaultLang, Lang ... langs) {
        return JenaModelHttpMessageConverter.create(defaultLang, null, langs);
    }

    public static JenaModelHttpMessageConverter create(Lang defaultLang, String regexPattern, Lang ... langs) {
        HashMap<MediaType, Lang> type2Lang = new HashMap<MediaType, Lang>();
        defaultLang.getAltContentTypes().stream().filter(s -> regexPattern == null || s.matches(regexPattern)).map(s -> MediaType.parseMediaType((String)s)).forEach(m -> type2Lang.put((MediaType)m, defaultLang));
        for (int i = 0; i < langs.length; ++i) {
            if (defaultLang.equals((Object)langs[i])) continue;
            langs[i].getAltContentTypes().stream().filter(s -> regexPattern == null || s.matches(regexPattern)).map(s -> MediaType.parseMediaType((String)s)).filter(m -> !type2Lang.containsKey(m)).forEach(m -> type2Lang.put((MediaType)m, defaultLang));
        }
        return new JenaModelHttpMessageConverter(defaultLang, type2Lang);
    }

    public static JenaModelHttpMessageConverter createForApplicationMediaTypes(Lang defaultLang) {
        return JenaModelHttpMessageConverter.create(defaultLang, "application/.*", SUPPORTED_LANGS);
    }

    public static JenaModelHttpMessageConverter createForTextMediaTypes(Lang defaultLang) {
        return JenaModelHttpMessageConverter.create(defaultLang, "text/.*", SUPPORTED_LANGS);
    }

    public static JenaModelHttpMessageConverter createForUserDefinedMediaTypes(Lang defaultLang) {
        return JenaModelHttpMessageConverter.create(defaultLang, "x/.*", SUPPORTED_LANGS);
    }
}

