/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.rdf.spring_jena;

import java.nio.charset.Charset;
import java.util.stream.Stream;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.riot.Lang;
import org.springframework.http.MediaType;

public class Jena2SpringUtils {
    public static final String[] SUPPORTED_MEDIA_TYPES = new String[]{"application/ld+json", "text/turtle", "application/turtle", "application/rdf+xml", "application/rdf+json", "text/plain", "application/n-triples", "text/plain", "application/xml", "text/xml", "application/trig", "application/n-quads", "text/trig", "application/rdf+protobuf", "application/rdf+thrift", "text/n-quads", "application/trix", "application/trix+xml", "text/rdf+n3", "application/n3", "text/n3"};

    private Jena2SpringUtils() {
    }

    public static MediaType contentType2MediaType(ContentType contentType) {
        Charset charset = null;
        if (contentType.getCharset() != null) {
            try {
                charset = Charset.forName(contentType.getCharset());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (charset != null) {
            return new MediaType(contentType.getType(), contentType.getSubType(), charset);
        }
        return new MediaType(contentType.getType(), contentType.getSubType());
    }

    public static String[] langs2MediaTypeStrings(Lang ... langs) {
        return (String[])Stream.of(langs).flatMap(l -> l.getAltContentTypes().stream()).toArray(String[]::new);
    }
}

