/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nio;

import com.sshtools.vfs2nio.Vfs2NioFileSystem;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.spi.FileSystemProvider;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.nio.BaseFileSystem;
import org.apache.nio.ImmutableList;

public abstract class BasePath<T extends BasePath<T, FS, P>, FS extends BaseFileSystem<T, P>, P extends FileSystemProvider>
implements Path {
    protected final ImmutableList<String> names;
    protected final String root;
    private final FS fileSystem;

    public BasePath(FS fileSystem, String root, ImmutableList<String> names) {
        this.fileSystem = fileSystem;
        this.root = root;
        this.names = names;
    }

    public BasePath(FS fileSystem, String root, String ... names) {
        this(fileSystem, root, new ImmutableList<String>(names));
    }

    @Override
    public int compareTo(Path paramPath) {
        T p1 = this.asT();
        T p2 = this.checkPath(paramPath);
        int c = this.compare(((BasePath)p1).root, ((BasePath)p2).root);
        if (c != 0) {
            return c;
        }
        for (int i = 0; i < Math.min(((BasePath)p1).names.size(), ((BasePath)p2).names.size()); ++i) {
            String n2;
            String n1 = ((BasePath)p1).names.get(i);
            c = this.compare(n1, n2 = ((BasePath)p2).names.get(i));
            if (c == 0) continue;
            return c;
        }
        return ((BasePath)p1).names.size() - ((BasePath)p2).names.size();
    }

    @Override
    public boolean endsWith(Path other) {
        T p1 = this.asT();
        T p2 = this.checkPath(other);
        if (((BasePath)p2).isAbsolute()) {
            return ((BasePath)p1).compareTo((Path)p2) == 0;
        }
        return this.endsWith(((BasePath)p1).names, ((BasePath)p2).names);
    }

    @Override
    public boolean endsWith(String other) {
        return this.endsWith((Path)((BaseFileSystem)this.getFileSystem()).getPath(other, new String[0]));
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Path && this.compareTo((Path)obj) == 0;
    }

    public T getFileName() {
        if (!this.names.isEmpty()) {
            return this.create(null, this.names.get(this.names.size() - 1));
        }
        return null;
    }

    public FS getFileSystem() {
        return this.fileSystem;
    }

    public T getName(int index) {
        int maxIndex = this.getNameCount();
        if (index < 0 || index >= maxIndex) {
            throw new IllegalArgumentException("Invalid name index " + index + " - not in range [0-" + maxIndex + "]");
        }
        return this.create((String)null, (ImmutableList<String>)this.names.subList(index, index + 1));
    }

    @Override
    public int getNameCount() {
        return this.names.size();
    }

    public T getParent() {
        if (this.names.isEmpty() || this.names.size() == 1 && this.root == null) {
            return null;
        }
        return this.create(this.root, (ImmutableList<String>)this.names.subList(0, this.names.size() - 1));
    }

    public T getRoot() {
        if (this.isAbsolute()) {
            return this.create(this.root, new String[0]);
        }
        return null;
    }

    @Override
    public int hashCode() {
        int hash = Objects.hashCode(this.getFileSystem());
        hash = 31 * hash + Objects.hashCode(this.root);
        for (String name : this.names) {
            hash = 31 * hash + Objects.hashCode(name);
        }
        return hash;
    }

    @Override
    public boolean isAbsolute() {
        return this.root != null;
    }

    @Override
    public Iterator<Path> iterator() {
        return new AbstractList<Path>(){

            @Override
            public Path get(int index) {
                return BasePath.this.getName(index);
            }

            @Override
            public int size() {
                return BasePath.this.getNameCount();
            }
        }.iterator();
    }

    public T normalize() {
        if (this.isNormal()) {
            return this.asT();
        }
        ArrayDeque<String> newNames = new ArrayDeque<String>();
        for (String name : this.names) {
            if (name.equals("..")) {
                String lastName = (String)newNames.peekLast();
                if (lastName != null && !lastName.equals("..")) {
                    newNames.removeLast();
                    continue;
                }
                if (this.isAbsolute()) continue;
                newNames.add(name);
                continue;
            }
            if (name.equals(".")) continue;
            newNames.add(name);
        }
        return newNames.equals(this.names) ? this.asT() : this.create(this.root, newNames);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.register(watcher, events, (WatchEvent.Modifier[])null);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException("Register to watch " + (BasePath)this.toAbsolutePath() + " N/A");
    }

    public T relativize(Path other) {
        T p1 = this.asT();
        T p2 = this.checkPath(other);
        if (!Objects.equals(((BasePath)p1).getRoot(), ((BasePath)p2).getRoot())) {
            throw new IllegalArgumentException("Paths have different roots: " + this + ", " + other);
        }
        if (((BasePath)p2).equals(p1)) {
            return this.create(null, new String[0]);
        }
        if (((BasePath)p1).root == null && ((BasePath)p1).names.isEmpty()) {
            return p2;
        }
        int sharedSubsequenceLength = 0;
        for (int i = 0; i < Math.min(((BasePath)p1).names.size(), ((BasePath)p2).names.size()) && ((BasePath)p1).names.get(i).equals(((BasePath)p2).names.get(i)); ++i) {
            ++sharedSubsequenceLength;
        }
        int extraNamesInThis = Math.max(0, ((BasePath)p1).names.size() - sharedSubsequenceLength);
        List extraNamesInOther = ((BasePath)p2).names.size() <= sharedSubsequenceLength ? Collections.emptyList() : ((BasePath)p2).names.subList(sharedSubsequenceLength, ((BasePath)p2).names.size());
        ArrayList<String> parts = new ArrayList<String>(extraNamesInThis + extraNamesInOther.size());
        parts.addAll(Collections.nCopies(extraNamesInThis, ".."));
        parts.addAll(extraNamesInOther);
        return this.create(null, parts);
    }

    public T resolve(Path other) {
        T p1 = this.asT();
        T p2 = this.checkPath(other);
        if (((BasePath)p2).isAbsolute()) {
            return p2;
        }
        if (((BasePath)p2).names.isEmpty()) {
            return p1;
        }
        String[] names = new String[((BasePath)p1).names.size() + ((BasePath)p2).names.size()];
        int index = 0;
        for (String p : ((BasePath)p1).names) {
            names[index++] = p;
        }
        for (String p : ((BasePath)p2).names) {
            names[index++] = p;
        }
        return this.create(((BasePath)p1).root, names);
    }

    public T resolve(String other) {
        return (T)this.resolve((Path)((BaseFileSystem)this.getFileSystem()).getPath(other, new String[0]));
    }

    @Override
    public Path resolveSibling(Path other) {
        Path parent = this.getParent();
        return parent == null ? other : ((BasePath)parent).resolve(other);
    }

    @Override
    public Path resolveSibling(String other) {
        return this.resolveSibling((Path)((BaseFileSystem)this.getFileSystem()).getPath(other, new String[0]));
    }

    @Override
    public boolean startsWith(Path other) {
        T p1 = this.asT();
        T p2 = this.checkPath(other);
        return Objects.equals(((BasePath)p1).getFileSystem(), ((BasePath)p2).getFileSystem()) && Objects.equals(((BasePath)p1).root, ((BasePath)p2).root) && this.startsWith(((BasePath)p1).names, ((BasePath)p2).names);
    }

    @Override
    public boolean startsWith(String other) {
        return this.startsWith((Path)((BaseFileSystem)this.getFileSystem()).getPath(other, new String[0]));
    }

    public T subpath(int beginIndex, int endIndex) {
        int maxIndex = this.getNameCount();
        if (beginIndex < 0 || beginIndex >= maxIndex || endIndex > maxIndex || beginIndex >= endIndex) {
            throw new IllegalArgumentException("subpath(" + beginIndex + "," + endIndex + ") bad index range - allowed [0-" + maxIndex + "]");
        }
        return this.create((String)null, (ImmutableList<String>)this.names.subList(beginIndex, endIndex));
    }

    public T toAbsolutePath() {
        if (this.isAbsolute()) {
            return this.asT();
        }
        return (T)((BasePath)((BaseFileSystem)this.fileSystem).getDefaultDir()).resolve(this);
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("To file " + (BasePath)this.toAbsolutePath() + " N/A");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.root != null) {
            sb.append(this.root);
        }
        String separator = ((BaseFileSystem)this.getFileSystem()).getSeparator();
        for (String name : this.names) {
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) != '/') {
                sb.append(separator);
            }
            sb.append(name);
        }
        return sb.toString();
    }

    @Override
    public URI toUri() {
        URI fsUri = ((Vfs2NioFileSystem)this.getFileSystem()).getUri();
        String str = fsUri + "/" + this.names.stream().collect(Collectors.joining("/"));
        try {
            return new URI(str);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected T asT() {
        return (T)this;
    }

    protected T checkPath(Path paramPath) {
        if (paramPath.getClass() != this.getClass()) {
            throw new ProviderMismatchException("Path is not of this class: " + paramPath + "[" + paramPath.getClass().getSimpleName() + "]");
        }
        BasePath t = (BasePath)paramPath;
        FileSystem fs = t.getFileSystem();
        if (fs.provider() != ((BaseFileSystem)this.fileSystem).provider()) {
            throw new ProviderMismatchException("Mismatched providers for " + t);
        }
        return (T)t;
    }

    protected int compare(String s1, String s2) {
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        return s2 == null ? 1 : s1.compareTo(s2);
    }

    protected T create(String root, Collection<String> names) {
        return this.create(root, new ImmutableList<String>(names.toArray(new String[names.size()])));
    }

    protected T create(String root, ImmutableList<String> names) {
        return (T)((BasePath)((BaseFileSystem)this.fileSystem).create(root, names));
    }

    protected T create(String root, String ... names) {
        return this.create(root, new ImmutableList<String>(names));
    }

    protected boolean endsWith(List<?> list, List<?> other) {
        return other.size() <= list.size() && list.subList(list.size() - other.size(), list.size()).equals(other);
    }

    protected boolean isNormal() {
        int count = this.getNameCount();
        if (count == 0 || count == 1 && !this.isAbsolute()) {
            return true;
        }
        boolean foundNonParentName = this.isAbsolute();
        boolean normal = true;
        for (String name : this.names) {
            if (name.equals("..")) {
                if (!foundNonParentName) continue;
                normal = false;
                break;
            }
            if (name.equals(".")) {
                normal = false;
                break;
            }
            foundNonParentName = true;
        }
        return normal;
    }

    protected boolean startsWith(List<?> list, List<?> other) {
        return list.size() >= other.size() && list.subList(0, other.size()).equals(other);
    }
}

