/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nio;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nio.ImmutableList;

public abstract class BaseFileSystem<T extends Path, P extends FileSystemProvider>
extends FileSystem {
    private final P fileSystemProvider;

    public BaseFileSystem(P fileSystemProvider) {
        this.fileSystemProvider = fileSystemProvider;
    }

    public T getDefaultDir() {
        return this.getPath("/", new String[0]);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        throw new UnsupportedOperationException("No file stores available");
    }

    public T getPath(String first, String ... more) {
        StringBuilder sb = new StringBuilder();
        if (first != null && first.length() > 0) {
            this.appendDedupSep(sb, first.replace('\\', '/'));
        }
        if (more.length > 0) {
            for (String segment : more) {
                if (sb.length() > 0 && sb.charAt(sb.length() - 1) != '/') {
                    sb.append('/');
                }
                this.appendDedupSep(sb, segment.replace('\\', '/'));
            }
        }
        if (sb.length() > 1 && sb.charAt(sb.length() - 1) == '/') {
            sb.setLength(sb.length() - 1);
        }
        String path = sb.toString();
        String root = null;
        if (path.startsWith("/")) {
            root = "/";
            path = path.substring(1);
        }
        String[] names = path.split("/");
        return this.create(root, names);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        int colonIndex = syntaxAndPattern.indexOf(58);
        if (colonIndex <= 0 || colonIndex == syntaxAndPattern.length() - 1) {
            throw new IllegalArgumentException("syntaxAndPattern must have form \"syntax:pattern\" but was \"" + syntaxAndPattern + "\"");
        }
        String syntax = syntaxAndPattern.substring(0, colonIndex);
        String pattern = syntaxAndPattern.substring(colonIndex + 1);
        final Pattern regex = Pattern.compile(switch (syntax) {
            case "glob" -> this.globToRegex(pattern);
            case "regex" -> pattern;
            default -> throw new UnsupportedOperationException("Unsupported path matcher syntax: '" + syntax + "'");
        });
        return new PathMatcher(){

            @Override
            public boolean matches(Path path) {
                Matcher m = regex.matcher(path.toString());
                return m.matches();
            }
        };
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singleton(this.create("/", new String[0]));
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException("UserPrincipalLookupService is not supported.");
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException("Watch service N/A");
    }

    public P provider() {
        return this.fileSystemProvider;
    }

    protected void appendDedupSep(StringBuilder sb, CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '/' && sb.length() != 0 && sb.charAt(sb.length() - 1) == '/') continue;
            sb.append(ch);
        }
    }

    protected T create(String root, Collection<String> names) {
        return this.create(root, new ImmutableList<String>(names.toArray(new String[names.size()])));
    }

    protected abstract T create(String var1, ImmutableList<String> var2);

    protected T create(String root, String ... names) {
        return this.create(root, new ImmutableList<String>(names));
    }

    protected String globToRegex(String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length());
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = pattern.toCharArray();
        block16: for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            switch (ch) {
                case '\\': {
                    if (++i >= arr.length) {
                        sb.append('\\');
                        continue block16;
                    }
                    char next = arr[i];
                    switch (next) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            sb.append("\\\\");
                            break;
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(next);
                    continue block16;
                }
                case '*': {
                    sb.append(inClass == 0 ? ".*" : "*");
                    continue block16;
                }
                case '?': {
                    sb.append(inClass == 0 ? (char)'.' : '?');
                    continue block16;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i + 1;
                    sb.append('[');
                    continue block16;
                }
                case ']': {
                    --inClass;
                    sb.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    continue block16;
                }
                case '!': {
                    sb.append(firstIndexInClass == i ? (char)'^' : '!');
                    continue block16;
                }
                case '{': {
                    ++inGroup;
                    sb.append('(');
                    continue block16;
                }
                case '}': {
                    --inGroup;
                    sb.append(')');
                    continue block16;
                }
                case ',': {
                    sb.append(inGroup > 0 ? (char)'|' : ',');
                    continue block16;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

