/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vfs2nio;

import com.fasterxml.jackson.core.io.DataOutputAsStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.vfs2.RandomAccessContent;

public class Vfs2NioSeekableByteChannel
implements SeekableByteChannel {
    protected RandomAccessContent content;
    protected ReadableByteChannel activeReadChannel = null;
    protected WritableByteChannel activeWriteChannel = null;
    protected boolean isOpen;

    public Vfs2NioSeekableByteChannel(RandomAccessContent content) {
        this(content, true);
    }

    public Vfs2NioSeekableByteChannel(RandomAccessContent content, boolean isOpen) {
        this.content = content;
        this.isOpen = isOpen;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    protected void closeActiveChannels() throws IOException {
        if (this.activeReadChannel != null) {
            this.activeReadChannel.close();
            this.activeReadChannel = null;
        }
        if (this.activeWriteChannel != null) {
            this.activeWriteChannel.close();
            this.activeWriteChannel = null;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.closeActiveChannels();
        }
        finally {
            this.content.close();
        }
        this.isOpen = false;
    }

    protected ReadableByteChannel getReadChannel() throws IOException {
        if (this.activeReadChannel == null) {
            this.activeReadChannel = Channels.newChannel(this.content.getInputStream());
        }
        return this.activeReadChannel;
    }

    protected WritableByteChannel getWriteChannel() throws IOException {
        if (this.activeWriteChannel == null) {
            this.activeWriteChannel = Channels.newChannel((OutputStream)new DataOutputAsStream((DataOutput)this.content));
        }
        return this.activeWriteChannel;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.getReadChannel().read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.getWriteChannel().write(src);
    }

    @Override
    public long position() throws IOException {
        return this.content.getFilePointer();
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        long currentPos = this.position();
        if (currentPos != newPosition) {
            this.closeActiveChannels();
            this.content.seek(newPosition);
        }
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.content.length();
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        this.content.setLength(size);
        return this;
    }
}

