/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vfs2nio;

import com.sshtools.vfs2nio.Vfs2NioFileAttributeView;
import com.sshtools.vfs2nio.Vfs2NioFileAttributes;
import com.sshtools.vfs2nio.Vfs2NioFileSystem;
import com.sshtools.vfs2nio.Vfs2NioFileSystemProvider;
import java.io.IOException;
import java.nio.file.AccessMode;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.nio.BasePath;
import org.apache.nio.ImmutableList;

public class Vfs2NioPath
extends BasePath<Vfs2NioPath, Vfs2NioFileSystem, Vfs2NioFileSystemProvider> {
    public Vfs2NioPath(Vfs2NioFileSystem fileSystem, String root, ImmutableList<String> names) {
        super(fileSystem, root, names);
    }

    public Vfs2NioPath(Vfs2NioFileSystem fileSystem, String root, String ... names) {
        super(fileSystem, root, names);
    }

    public FileObject toFileObject() {
        return ((Vfs2NioFileSystem)this.getFileSystem()).pathToFileObject(this);
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        Vfs2NioPath absolute = (Vfs2NioPath)this.toAbsolutePath();
        FileSystem fs = this.getFileSystem();
        FileSystemProvider provider = fs.provider();
        provider.checkAccess(absolute, new AccessMode[0]);
        return absolute;
    }

    boolean exists() {
        return ((Vfs2NioFileSystem)this.getFileSystem()).exists((Vfs2NioPath)this.normalize());
    }

    Vfs2NioFileAttributes getAttributes() throws IOException {
        Vfs2NioFileAttributes zfas = ((Vfs2NioFileSystem)this.getFileSystem()).getFileAttributes((Vfs2NioPath)this.normalize());
        if (zfas == null) {
            throw new NoSuchFileException(this.toString());
        }
        return zfas;
    }

    FileStore getFileStore() throws IOException {
        if (this.exists()) {
            return ((Vfs2NioFileSystem)this.getFileSystem()).getFileStore(this);
        }
        throw new NoSuchFileException(((Vfs2NioPath)this.normalize()).toString());
    }

    Map<String, Object> readAttributes(String attributes, LinkOption ... options) throws IOException {
        String view = null;
        String attrs = null;
        int colonPos = attributes.indexOf(58);
        if (colonPos == -1) {
            view = "basic";
            attrs = attributes;
        } else {
            view = attributes.substring(0, colonPos++);
            attrs = attributes.substring(colonPos);
        }
        Vfs2NioFileAttributeView zfv = Vfs2NioFileAttributeView.get(this, view);
        if (zfv == null) {
            throw new UnsupportedOperationException("view not supported");
        }
        return zfv.readAttributes(attrs);
    }

    void setAttribute(String attribute, Object value, LinkOption ... options) throws IOException {
        String type = null;
        String attr = null;
        int colonPos = attribute.indexOf(58);
        if (colonPos == -1) {
            type = "basic";
            attr = attribute;
        } else {
            type = attribute.substring(0, colonPos++);
            attr = attribute.substring(colonPos);
        }
        Vfs2NioFileAttributeView view = Vfs2NioFileAttributeView.get(this, type);
        if (view == null) {
            throw new UnsupportedOperationException("view <" + view + "> is not supported");
        }
        view.setAttribute(attr, value);
    }

    void setTimes(FileTime mtime, FileTime atime, FileTime ctime) throws IOException {
        ((Vfs2NioFileSystem)this.getFileSystem()).setTimes((Vfs2NioPath)this.normalize(), mtime, atime, ctime);
    }
}

