/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vfs2nio;

import com.sshtools.vfs2nio.FileChannelFromSeekableByteChannelImpl;
import com.sshtools.vfs2nio.Vfs2NioDirectoryStream;
import com.sshtools.vfs2nio.Vfs2NioException;
import com.sshtools.vfs2nio.Vfs2NioFileAttributeView;
import com.sshtools.vfs2nio.Vfs2NioFileAttributes;
import com.sshtools.vfs2nio.Vfs2NioFileSystem;
import com.sshtools.vfs2nio.Vfs2NioPath;
import com.sshtools.vfs2nio.Vfs2NioSeekableByteChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class Vfs2NioFileSystemProvider
extends FileSystemProvider {
    public static final String FILE_SYSTEM_OPTIONS = "com.sshtools.vfs2nio.fileSystemOptions";
    public static final String VFS_MANAGER = "com.sshtools.vfs2nio.vfsManager";
    private final Map<URI, Vfs2NioFileSystem> filesystems = Collections.synchronizedMap(new HashMap());

    static final Vfs2NioPath toVFSPath(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof Vfs2NioPath)) {
            throw new ProviderMismatchException();
        }
        return (Vfs2NioPath)path;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        Vfs2NioPath p = Vfs2NioFileSystemProvider.toVFSPath(path);
        FileObject fo = p.toFileObject();
        if (modes.length == 0) {
            modes = new AccessMode[]{AccessMode.READ};
        }
        block5: for (AccessMode m : modes) {
            switch (m) {
                case EXECUTE: {
                    if (fo.isExecutable()) continue block5;
                    throw new AccessDeniedException(String.format("No %s access to %s", new Object[]{m, path}));
                }
                case READ: {
                    if (fo.isReadable()) continue block5;
                    throw new AccessDeniedException(String.format("No %s access to %s", new Object[]{m, path}));
                }
                case WRITE: {
                    if (fo.isWriteable()) continue block5;
                    throw new AccessDeniedException(String.format("No %s access to %s", new Object[]{m, path}));
                }
            }
        }
    }

    @Override
    public void copy(Path src, Path target, CopyOption ... options) throws IOException {
        Vfs2NioFileSystemProvider.toVFSPath(target).toFileObject().copyFrom(Vfs2NioFileSystemProvider.toVFSPath(src).toFileObject(), (FileSelector)new AllFileSelector());
    }

    @Override
    public void createDirectory(Path path, FileAttribute<?> ... attrs) throws IOException {
        Vfs2NioPath p = Vfs2NioFileSystemProvider.toVFSPath(path);
        this.checkAccess(p, AccessMode.WRITE);
        FileObject fo = p.toFileObject();
        fo.createFolder();
    }

    @Override
    public final void delete(Path path) throws IOException {
        Vfs2NioPath p = Vfs2NioFileSystemProvider.toVFSPath(path);
        this.checkAccess(p, AccessMode.WRITE);
        FileObject fo = p.toFileObject();
        fo.deleteAll();
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return Vfs2NioFileAttributeView.get(Vfs2NioFileSystemProvider.toVFSPath(path), type);
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return Vfs2NioFileSystemProvider.toVFSPath(path).getFileStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem getFileSystem(URI uri) {
        Map<URI, Vfs2NioFileSystem> map = this.filesystems;
        synchronized (map) {
            Vfs2NioFileSystem vfs = null;
            URI path = this.toFsUri(uri);
            vfs = this.filesystems.get(path);
            if (vfs == null) {
                throw new FileSystemNotFoundException(String.format("Cannot find file system for %s", uri));
            }
            return vfs;
        }
    }

    @Override
    public Path getPath(URI uri) {
        FileSystem fileSystem;
        try {
            fileSystem = this.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException fsnfe) {
            try {
                fileSystem = this.newFileSystem(uri, new HashMap());
            }
            catch (IOException e) {
                throw new Vfs2NioException("Failed to create new file system.", e);
            }
        }
        return fileSystem.getPath(this.toFsUri(uri).getSchemeSpecificPart(), new String[0]);
    }

    @Override
    public String getScheme() {
        return "vfs";
    }

    @Override
    public boolean isHidden(Path path) {
        try {
            return Vfs2NioFileSystemProvider.toVFSPath(path).toFileObject().isHidden();
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    @Override
    public boolean isSameFile(Path path, Path other) throws IOException {
        return Vfs2NioFileSystemProvider.toVFSPath(path).toFileObject().equals(Vfs2NioFileSystemProvider.toVFSPath(other).toFileObject());
    }

    @Override
    public void move(Path src, Path target, CopyOption ... options) throws IOException {
        Vfs2NioFileSystemProvider.toVFSPath(src).toFileObject().moveTo(Vfs2NioFileSystemProvider.toVFSPath(target).toFileObject());
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService exec, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return new Vfs2NioDirectoryStream(Vfs2NioFileSystemProvider.toVFSPath(path), filter);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        RandomAccessMode accessMode = options.contains(StandardOpenOption.WRITE) ? RandomAccessMode.READWRITE : RandomAccessMode.READ;
        Vfs2NioPath vfsPath = Vfs2NioFileSystemProvider.toVFSPath(path);
        FileObject fileObject = vfsPath.toFileObject();
        RandomAccessContent content = fileObject.getContent().getRandomAccessContent(accessMode);
        return new FileChannelFromSeekableByteChannelImpl(new Vfs2NioSeekableByteChannel(content));
    }

    @Override
    public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        URI path = this.toFsUri(uri);
        if (this.filesystems.containsKey(path)) {
            throw new FileSystemAlreadyExistsException();
        }
        Map<URI, Vfs2NioFileSystem> map = this.filesystems;
        synchronized (map) {
            FileSystemManager mgr;
            FileSystemManager fileSystemManager = mgr = env == null ? null : (FileSystemManager)env.get(VFS_MANAGER);
            if (mgr == null) {
                mgr = VFS.getManager();
            }
            FileSystemOptions opts = env == null ? null : (FileSystemOptions)env.get(FILE_SYSTEM_OPTIONS);
            Vfs2NioFileSystem vfs = new Vfs2NioFileSystem(this, opts == null ? mgr.resolveFile(path) : mgr.resolveFile(path.toString(), opts), path);
            this.filesystems.put(path, vfs);
            return vfs;
        }
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        List<OpenOption> optlist = Arrays.asList(options);
        if (optlist.contains(StandardOpenOption.WRITE)) {
            throw new IllegalArgumentException(String.format("%s is not supported by this method.", StandardOpenOption.WRITE));
        }
        this.checkAccess(path, AccessMode.READ);
        return Vfs2NioFileSystemProvider.toVFSPath(path).toFileObject().getContent().getInputStream();
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        List<OpenOption> optlist = Arrays.asList(options);
        if (optlist.contains(StandardOpenOption.READ)) {
            throw new IllegalArgumentException(String.format("%s is not supported by this method.", StandardOpenOption.READ));
        }
        FileObject fo = Vfs2NioFileSystemProvider.toVFSPath(path).toFileObject();
        if (optlist.contains(StandardOpenOption.CREATE_NEW) && fo.exists()) {
            throw new IOException(String.format("%s already exists, and the option %s was specified.", fo, StandardOpenOption.CREATE_NEW));
        }
        this.checkAccess(path, AccessMode.WRITE);
        return fo.getContent().getOutputStream(optlist.contains(StandardOpenOption.APPEND));
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (type == BasicFileAttributes.class || type == Vfs2NioFileAttributes.class) {
            return (A)Vfs2NioFileSystemProvider.toVFSPath(path).getAttributes();
        }
        return null;
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attribute, LinkOption ... options) throws IOException {
        return Vfs2NioFileSystemProvider.toVFSPath(path).readAttributes(attribute, options);
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        Vfs2NioFileSystemProvider.toVFSPath(path).setAttribute(attribute, value, options);
    }

    protected URI toFsUri(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException(String.format("URI scheme must be %s", this.getScheme()));
        }
        try {
            String spec = uri.getSchemeSpecificPart();
            int sep = spec.indexOf("!/");
            if (sep != -1) {
                spec = spec.substring(0, sep);
            }
            URI u = new URI(spec);
            return u;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    protected Path XXuriToPath(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException("URI scheme is not '" + this.getScheme() + "'");
        }
        try {
            String spec = uri.getSchemeSpecificPart();
            int sep = spec.indexOf("!/");
            if (sep != -1) {
                spec = spec.substring(0, sep);
            }
            URI u = new URI(spec);
            return Paths.get(u).toAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    void removeFileSystem(URI path) throws IOException {
        this.filesystems.remove(path);
    }
}

