/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vfs2nio;

import com.sshtools.vfs2nio.Vfs2NioException;
import com.sshtools.vfs2nio.Vfs2NioFileAttributes;
import com.sshtools.vfs2nio.Vfs2NioFileStore;
import com.sshtools.vfs2nio.Vfs2NioFileSystemProvider;
import com.sshtools.vfs2nio.Vfs2NioPath;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.nio.BaseFileSystem;
import org.apache.nio.ImmutableList;

public class Vfs2NioFileSystem
extends BaseFileSystem<Vfs2NioPath, Vfs2NioFileSystemProvider> {
    private static final Set<String> supportedFileAttributeViews = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("basic", "vfs")));
    private boolean open = true;
    private FileObject root;
    private URI uri;

    public Vfs2NioFileSystem(Vfs2NioFileSystemProvider provider, FileObject root, URI uri) throws FileSystemException {
        super(provider);
        this.root = root;
        this.uri = uri;
    }

    @Override
    public void close() throws IOException {
        if (!this.open) {
            throw new IOException("Not open");
        }
        this.open = false;
        ((Vfs2NioFileSystemProvider)this.provider()).removeFileSystem(this.uri);
    }

    public Vfs2NioFileAttributes getFileAttributes(Vfs2NioPath path) {
        return new Vfs2NioFileAttributes(this.pathToFileObject(path));
    }

    public URI getUri() {
        return this.uri;
    }

    public FileObject getRoot() {
        return this.root;
    }

    public long getTotalSpace() {
        return 0L;
    }

    public long getUnallocatedSpace() {
        return 0L;
    }

    public long getUsableSpace() {
        return 0L;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public boolean isReadOnly() {
        try {
            return !this.root.isWriteable();
        }
        catch (FileSystemException e) {
            return true;
        }
    }

    public static String[] getPathSegments(Path path) {
        int n = path.getNameCount();
        String[] result = new String[n];
        Iterator<Path> it = path.iterator();
        for (int i = 0; i < n; ++i) {
            String segment;
            result[i] = segment = it.next().toString();
        }
        return result;
    }

    public Iterator<Path> iterator(final Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        FileObject obj = this.pathToFileObject(Vfs2NioFileSystemProvider.toVFSPath(path));
        final FileObject[] children = obj.getChildren();
        final String[] baseNames = Vfs2NioFileSystem.getPathSegments(path);
        final int childNameIdx = baseNames.length;
        return new Iterator<Path>(){
            int index;

            @Override
            public boolean hasNext() {
                return this.index < children.length;
            }

            @Override
            public Path next() {
                Path croot = path.getRoot();
                String[] childNames = Arrays.copyOf(baseNames, childNameIdx + 1);
                childNames[childNameIdx] = children[this.index].getName().getBaseName().toString();
                ++this.index;
                return new Vfs2NioPath(Vfs2NioFileSystem.this, croot.toString(), childNames);
            }
        };
    }

    public void setTimes(Vfs2NioPath path, FileTime mtime, FileTime atime, FileTime ctime) {
        if (atime != null || ctime != null) {
            throw new UnsupportedOperationException();
        }
        FileObject object = this.pathToFileObject(path);
        try {
            object.getContent().setLastModifiedTime(mtime.toMillis());
        }
        catch (FileSystemException e) {
            throw new Vfs2NioException("Failed to set last modified.", e);
        }
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return supportedFileAttributeViews;
    }

    @Override
    protected Vfs2NioPath create(String root, ImmutableList<String> names) {
        return new Vfs2NioPath(this, root, names);
    }

    boolean exists(Vfs2NioPath path) {
        try {
            return this.pathToFileObject(path).exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    FileStore getFileStore(Vfs2NioPath path) {
        return new Vfs2NioFileStore(path);
    }

    FileObject pathToFileObject(Vfs2NioPath path) {
        try {
            return this.root.resolveFile(path.toString());
        }
        catch (FileSystemException e) {
            throw new Vfs2NioException("Failed to resolve.", e);
        }
    }
}

