/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vfs2nio;

import com.sshtools.vfs2nio.Vfs2NioFileAttributeView;
import com.sshtools.vfs2nio.Vfs2NioFileSystem;
import com.sshtools.vfs2nio.Vfs2NioPath;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;

public class Vfs2NioFileStore
extends FileStore {
    private final Vfs2NioFileSystem fs;

    Vfs2NioFileStore(Vfs2NioPath zpath) {
        this.fs = (Vfs2NioFileSystem)zpath.getFileSystem();
    }

    @Override
    public Object getAttribute(String attribute) throws IOException {
        if (attribute.equals("totalSpace")) {
            return this.getTotalSpace();
        }
        if (attribute.equals("usableSpace")) {
            return this.getUsableSpace();
        }
        if (attribute.equals("unallocatedSpace")) {
            return this.getUnallocatedSpace();
        }
        throw new UnsupportedOperationException(String.format("Attribute %s is not supported.", attribute));
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        return null;
    }

    @Override
    public long getTotalSpace() throws IOException {
        return new CVFS2NioFSFileStoreAttributes(this).totalSpace();
    }

    @Override
    public long getUnallocatedSpace() throws IOException {
        return new CVFS2NioFSFileStoreAttributes(this).unallocatedSpace();
    }

    @Override
    public long getUsableSpace() throws IOException {
        return new CVFS2NioFSFileStoreAttributes(this).usableSpace();
    }

    @Override
    public boolean isReadOnly() {
        return this.fs.isReadOnly();
    }

    @Override
    public String name() {
        return this.fs.toString() + "/";
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        return type == BasicFileAttributeView.class || type == Vfs2NioFileAttributeView.class;
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        return name.equals("basic") || name.equals("vfs");
    }

    @Override
    public String type() {
        return "vfs";
    }

    private static class CVFS2NioFSFileStoreAttributes {
        Vfs2NioFileStore fstore;

        public CVFS2NioFSFileStoreAttributes(Vfs2NioFileStore fstore) throws IOException {
            this.fstore = fstore;
        }

        public long totalSpace() {
            return this.fstore.fs.getTotalSpace();
        }

        public long unallocatedSpace() throws IOException {
            if (!this.fstore.isReadOnly()) {
                return this.fstore.fs.getUnallocatedSpace();
            }
            return 0L;
        }

        public long usableSpace() throws IOException {
            if (!this.fstore.isReadOnly()) {
                return this.fstore.fs.getUsableSpace();
            }
            return 0L;
        }
    }
}

