/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vfs2nio;

import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;

public class Vfs2NioFileAttributes
implements BasicFileAttributes {
    private final FileObject e;

    Vfs2NioFileAttributes(FileObject e) {
        this.e = e;
    }

    public Map<String, Object> attributes() {
        try {
            return this.e.getContent().getAttributes();
        }
        catch (FileSystemException fileSystemException) {
            return Collections.emptyMap();
        }
    }

    public Certificate[] certificates() {
        try {
            return this.e.getContent().getCertificates();
        }
        catch (FileSystemException fileSystemException) {
            return null;
        }
    }

    public String contentEncoding() {
        try {
            FileContentInfo info = this.e.getContent().getContentInfo();
            if (info != null) {
                return info.getContentEncoding();
            }
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        return null;
    }

    public String contentType() {
        try {
            FileContentInfo info = this.e.getContent().getContentInfo();
            if (info != null) {
                return info.getContentType();
            }
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public FileTime creationTime() {
        return null;
    }

    @Override
    public Object fileKey() {
        return null;
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.e.getType() == FileType.FILE_OR_FOLDER || this.e.getType() == FileType.FOLDER;
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public boolean isRegularFile() {
        try {
            return this.e.getType() == FileType.FILE;
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public FileTime lastAccessTime() {
        return null;
    }

    @Override
    public FileTime lastModifiedTime() {
        try {
            return FileTime.fromMillis(this.e.getContent().getLastModifiedTime());
        }
        catch (FileSystemException e) {
            return null;
        }
    }

    @Override
    public long size() {
        try {
            return this.e.getContent().getSize();
        }
        catch (FileSystemException e) {
            return 0L;
        }
    }
}

