/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vfs2nio;

import com.sshtools.vfs2nio.Vfs2NioFileAttributes;
import com.sshtools.vfs2nio.Vfs2NioPath;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.LinkedHashMap;
import java.util.Map;

public class Vfs2NioFileAttributeView
implements BasicFileAttributeView {
    private final Vfs2NioPath path;
    private final boolean vfs;

    static <V extends FileAttributeView> V get(Vfs2NioPath path, Class<V> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type == BasicFileAttributeView.class) {
            return (V)new Vfs2NioFileAttributeView(path, false);
        }
        if (type == Vfs2NioFileAttributeView.class) {
            return (V)new Vfs2NioFileAttributeView(path, true);
        }
        return null;
    }

    static Vfs2NioFileAttributeView get(Vfs2NioPath path, String type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type.equals("basic")) {
            return new Vfs2NioFileAttributeView(path, false);
        }
        if (type.equals("vfs")) {
            return new Vfs2NioFileAttributeView(path, true);
        }
        return null;
    }

    private Vfs2NioFileAttributeView(Vfs2NioPath path, boolean isZipView) {
        this.path = path;
        this.vfs = isZipView;
    }

    @Override
    public String name() {
        return this.vfs ? "vfs" : "basic";
    }

    @Override
    public Vfs2NioFileAttributes readAttributes() throws IOException {
        return this.path.getAttributes();
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        this.path.setTimes(lastModifiedTime, lastAccessTime, createTime);
    }

    Object attribute(Attribute id, Vfs2NioFileAttributes attributes) {
        switch (id) {
            case size: {
                return attributes.size();
            }
            case creationTime: {
                return attributes.creationTime();
            }
            case lastAccessTime: {
                return attributes.lastAccessTime();
            }
            case lastModifiedTime: {
                return attributes.lastModifiedTime();
            }
            case isDirectory: {
                return attributes.isDirectory();
            }
            case isRegularFile: {
                return attributes.isRegularFile();
            }
            case isSymbolicLink: {
                return attributes.isSymbolicLink();
            }
            case isOther: {
                return attributes.isOther();
            }
            case fileKey: {
                return attributes.fileKey();
            }
        }
        if (this.vfs) {
            switch (id) {
                case contentType: {
                    return attributes.contentType();
                }
                case contentEncoding: {
                    return attributes.contentEncoding();
                }
                case certificates: {
                    return attributes.certificates();
                }
                case attributes: {
                    return attributes.attributes();
                }
            }
        }
        return null;
    }

    Map<String, Object> readAttributes(String attributes) throws IOException {
        Vfs2NioFileAttributes zfas = this.readAttributes();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if ("*".equals(attributes)) {
            for (Attribute id : Attribute.values()) {
                try {
                    map.put(id.name(), this.attribute(id, zfas));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        } else {
            String[] as;
            for (String a : as = attributes.split(",")) {
                try {
                    map.put(a, this.attribute(Attribute.valueOf(a), zfas));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return map;
    }

    void setAttribute(String attribute, Object value) throws IOException {
        try {
            if (Attribute.valueOf(attribute) == Attribute.lastModifiedTime) {
                this.setTimes((FileTime)value, null, null);
            }
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException("'" + attribute + "' is unknown or read-only attribute");
        }
    }

    private static enum Attribute {
        attributes,
        certificates,
        contentEncoding,
        contentType,
        creationTime,
        fileKey,
        isDirectory,
        isOther,
        isRegularFile,
        isSymbolicLink,
        lastAccessTime,
        lastModifiedTime,
        size;

    }
}

