/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vfs2nio;

import com.sshtools.vfs2nio.Vfs2NioFileSystem;
import com.sshtools.vfs2nio.Vfs2NioPath;
import java.io.IOException;
import java.nio.file.ClosedDirectoryStreamException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Vfs2NioDirectoryStream
implements DirectoryStream<Path> {
    private final DirectoryStream.Filter<? super Path> filter;
    private final Vfs2NioFileSystem fs;
    private volatile Iterator<Path> iterator;
    private volatile boolean open = true;
    private final Path path;

    Vfs2NioDirectoryStream(Vfs2NioPath zipPath, DirectoryStream.Filter<? super Path> filter) throws IOException {
        this.fs = (Vfs2NioFileSystem)zipPath.getFileSystem();
        this.path = zipPath.normalize();
        this.filter = filter;
        if (!Files.isDirectory(this.path, new LinkOption[0])) {
            throw new NotDirectoryException(zipPath.toString());
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.open = false;
    }

    @Override
    public synchronized Iterator<Path> iterator() {
        if (!this.open) {
            throw new ClosedDirectoryStreamException();
        }
        if (this.iterator != null) {
            throw new IllegalStateException();
        }
        try {
            this.iterator = this.fs.iterator(this.path, this.filter);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return new Iterator<Path>(){

            @Override
            public boolean hasNext() {
                if (!Vfs2NioDirectoryStream.this.open) {
                    return false;
                }
                return Vfs2NioDirectoryStream.this.iterator.hasNext();
            }

            @Override
            public synchronized Path next() {
                if (!Vfs2NioDirectoryStream.this.open) {
                    throw new NoSuchElementException();
                }
                return Vfs2NioDirectoryStream.this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

