/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vfs2nio;

import com.sshtools.vfs2nio.ChannelUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;

public abstract class FileChannelFromSeekableByteChannelBase
extends FileChannel {
    protected abstract SeekableByteChannel getSeekableByteChannel();

    protected abstract int getBlockSize();

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.getSeekableByteChannel().read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return ChannelUtils.readScattered(this.getSeekableByteChannel(), dsts, offset, length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.getSeekableByteChannel().write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return ChannelUtils.writeScattered(this.getSeekableByteChannel(), srcs, offset, length);
    }

    @Override
    public long position() throws IOException {
        return this.getSeekableByteChannel().position();
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        this.getSeekableByteChannel().position(newPosition);
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.getSeekableByteChannel().size();
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        this.getSeekableByteChannel().truncate(size);
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        return ChannelUtils.transferTo(this.getSeekableByteChannel(), position, count, target, this.getBlockSize());
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        return ChannelUtils.transferFrom(this.getSeekableByteChannel(), src, position, count, this.getBlockSize());
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        return ChannelUtils.read(this.getSeekableByteChannel(), dst, position);
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        return ChannelUtils.write(this.getSeekableByteChannel(), src, position);
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.getSeekableByteChannel().close();
    }
}

