/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vfs2nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;

public class ChannelUtils {
    public static int readFully(ReadableByteChannel src, ByteBuffer dst) throws IOException {
        int n;
        int count = 0;
        while (dst.remaining() > 0 && (n = src.read(dst)) >= 0) {
            count += n;
        }
        return count;
    }

    public static int writeFully(WritableByteChannel tgt, ByteBuffer buffer) throws IOException {
        int result = 0;
        while (buffer.remaining() > 0) {
            result += tgt.write(buffer);
        }
        return result;
    }

    public static int read(SeekableByteChannel src, ByteBuffer dst, long position) throws IOException {
        long posBackup = src.position();
        src.position(position);
        int result = src.read(dst);
        src.position(posBackup);
        return result;
    }

    public static int write(SeekableByteChannel dst, ByteBuffer src, long position) throws IOException {
        long posBackup = dst.position();
        dst.position(position);
        int result = dst.write(src);
        dst.position(posBackup);
        return result;
    }

    public static long transferTo(SeekableByteChannel src, long position, long count, WritableByteChannel target, int blockSize) throws IOException {
        long remaining;
        long posBackup = src.position();
        src.position(position);
        ByteBuffer buffer = ByteBuffer.allocate(blockSize);
        long done = 0L;
        while ((remaining = count - done) > 0L) {
            buffer.position(0);
            int limit = remaining > (long)blockSize ? blockSize : (int)remaining;
            buffer.limit(limit);
            int n = ChannelUtils.readFully(src, buffer);
            if (n == 0) break;
            done += (long)n;
            buffer.position(0);
            buffer.limit(n);
            ChannelUtils.writeFully(target, buffer);
        }
        src.position(posBackup);
        return done;
    }

    public static long transferFrom(SeekableByteChannel dst, ReadableByteChannel src, long position, long count, int blockSize) throws IOException {
        long remaining;
        ByteBuffer buffer = ByteBuffer.allocate(blockSize);
        long posBackup = dst.position();
        dst.position(position);
        long done = 0L;
        while ((remaining = count - done) > 0L) {
            buffer.position(0);
            int limit = remaining > (long)blockSize ? blockSize : (int)remaining;
            buffer.limit(limit);
            int contentSize = ChannelUtils.readFully(src, buffer);
            if (contentSize == 0) break;
            done += (long)contentSize;
            buffer.position(0);
            buffer.limit(contentSize);
            ChannelUtils.writeFully(dst, buffer);
        }
        dst.position(posBackup);
        return done;
    }

    public static long readScattered(ReadableByteChannel src, ByteBuffer[] dsts, int offset, int length) throws IOException {
        ByteBuffer dst;
        int n;
        long result = 0L;
        for (int i = offset; i < length && (n = ChannelUtils.readFully(src, dst = dsts[i])) != 0; ++i) {
            result += (long)n;
        }
        return result;
    }

    public static long writeScattered(WritableByteChannel dst, ByteBuffer[] srcs, int offset, int length) throws IOException {
        ByteBuffer src;
        int n;
        long result = 0L;
        for (int i = offset; i < length && (n = ChannelUtils.writeFully(dst, src = srcs[i])) != 0; ++i) {
            result += (long)n;
        }
        return result;
    }
}

