/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.registry.codec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aksw.shellgebra.registry.codec.CodecVariant;

public class CodecSpec {
    private String name;
    private List<CodecVariant> decoderVariants = new ArrayList<CodecVariant>();
    private List<CodecVariant> encoderVariants = new ArrayList<CodecVariant>();

    private CodecSpec(String name, List<CodecVariant> decoderVariants, List<CodecVariant> encoderVariants) {
        this.name = name;
        this.decoderVariants = decoderVariants;
        this.encoderVariants = encoderVariants;
    }

    public String getName() {
        return this.name;
    }

    public List<CodecVariant> getDecoderVariants() {
        return this.decoderVariants;
    }

    public List<CodecVariant> getEncoderVariants() {
        return this.encoderVariants;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(CodecSpec spec) {
        return CodecSpec.newBuilder().setName(spec.getName()).addDecoderVariants(spec.getDecoderVariants()).addEncoderVariants(spec.getEncoderVariants());
    }

    public static class Builder {
        private String name;
        private List<CodecVariant> decoderVariants = new ArrayList<CodecVariant>();
        private List<CodecVariant> encoderVariants = new ArrayList<CodecVariant>();

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder addDecoderVariant(CodecVariant codecVariant) {
            this.decoderVariants.add(codecVariant);
            return this;
        }

        public Builder addDecoderVariants(Collection<CodecVariant> codecVariants) {
            this.decoderVariants.addAll(codecVariants);
            return this;
        }

        public Builder addEncoderVariant(CodecVariant codecVariant) {
            this.encoderVariants.add(codecVariant);
            return this;
        }

        public Builder addEncoderVariants(Collection<CodecVariant> codecVariants) {
            this.encoderVariants.addAll(codecVariants);
            return this;
        }

        public CodecSpec build() {
            return new CodecSpec(this.name, List.copyOf(this.decoderVariants), List.copyOf(this.encoderVariants));
        }
    }
}

