/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.stream.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.aksw.shellgebra.algebra.common.OpSpecTranscoding;
import org.aksw.shellgebra.algebra.stream.op.StreamOp;
import org.aksw.shellgebra.algebra.stream.op.StreamOpCommand;
import org.aksw.shellgebra.algebra.stream.op.StreamOpConcat;
import org.aksw.shellgebra.algebra.stream.op.StreamOpContentConvert;
import org.aksw.shellgebra.algebra.stream.op.StreamOpFile;
import org.aksw.shellgebra.algebra.stream.op.StreamOpTranscode;
import org.aksw.shellgebra.algebra.stream.op.StreamOpVar;
import org.aksw.shellgebra.algebra.stream.op.StreamOpVisitor;

public class StreamOpVisitorFileName
implements StreamOpVisitor<FileName> {
    protected Function<String, ? extends StreamOp> varNameResolver;

    public StreamOpVisitorFileName() {
        this(null);
    }

    public StreamOpVisitorFileName(Function<String, ? extends StreamOp> varNameResolver) {
        this.varNameResolver = varNameResolver;
    }

    @Override
    public FileName visit(StreamOpFile op) {
        return new FileName(op.getPath(), List.of());
    }

    @Override
    public FileName visit(StreamOpTranscode op) {
        FileName base = op.getSubOp().accept(this);
        ArrayList<OpSpecTranscoding> transcodings = new ArrayList<OpSpecTranscoding>(base.transcodings());
        transcodings.add(op.getTranscoding());
        return new FileName(base.baseName(), List.copyOf(transcodings));
    }

    @Override
    public FileName visit(StreamOpContentConvert op) {
        FileName base = op.getSubOp().accept(this);
        return base;
    }

    @Override
    public FileName visit(StreamOpConcat op) {
        throw new UnsupportedOperationException("Filename generation not implemented for this operator: " + String.valueOf(op));
    }

    @Override
    public FileName visit(StreamOpCommand op) {
        throw new UnsupportedOperationException("Filename generation not implemented for this operator: " + String.valueOf(op));
    }

    @Override
    public FileName visit(StreamOpVar op) {
        StreamOp subOp;
        if (this.varNameResolver != null) {
            String varName = op.getVarName();
            subOp = this.varNameResolver.apply(varName);
            if (subOp == null) {
                throw new RuntimeException("Variable name " + varName + " could not be resolved to a sub op.");
            }
        } else {
            throw new UnsupportedOperationException("Filename generation not implemented for this operator: " + String.valueOf(op));
        }
        FileName result = subOp.accept(this);
        return result;
    }

    public record FileName(String baseName, List<OpSpecTranscoding> transcodings) {
    }
}

