/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.stream.transform;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.aksw.shellgebra.algebra.stream.op.StreamOp;
import org.aksw.shellgebra.algebra.stream.op.StreamOpCommand;
import org.aksw.shellgebra.algebra.stream.op.StreamOpConcat;
import org.aksw.shellgebra.algebra.stream.op.StreamOpContentConvert;
import org.aksw.shellgebra.algebra.stream.op.StreamOpFile;
import org.aksw.shellgebra.algebra.stream.op.StreamOpTranscode;
import org.aksw.shellgebra.algebra.stream.op.StreamOpVar;
import org.aksw.shellgebra.algebra.stream.transformer.StreamOpEntry;
import org.aksw.shellgebra.algebra.stream.transformer.StreamOpTransform;
import org.aksw.shellgebra.algebra.stream.transformer.StreamOpTransformGeneric;
import org.aksw.shellgebra.algebra.stream.transformer.StreamOpTransformer;

public class StreamOpTransformExecutionPartitioner
implements StreamOpTransformGeneric<StreamOpEntry<Location>> {
    protected StreamOpTransform sysCallTransform;
    protected Map<String, StreamOp> varToOp = new LinkedHashMap<String, StreamOp>();
    protected int nextVar = 0;

    public StreamOpTransformExecutionPartitioner(StreamOpTransform sysCallTransform) {
        this.sysCallTransform = Objects.requireNonNull(sysCallTransform);
    }

    public Map<String, StreamOp> getVarToOp() {
        return this.varToOp;
    }

    protected boolean isSupported(StreamOpTranscode op) {
        boolean result;
        try {
            StreamOp testOp = StreamOpTransformer.transform(op, this.sysCallTransform);
            result = testOp instanceof StreamOpCommand;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public StreamOpEntry<Location> transform(StreamOpTranscode op, StreamOpEntry<Location> subOp) {
        boolean isSupported;
        StreamOpEntry<Location> result = null;
        if (subOp.getValue() == Location.HANDLED && !(isSupported = this.isSupported(op))) {
            StreamOpTranscode thisOp = new StreamOpTranscode(op.getTranscoding(), subOp.getStreamOp());
            result = this.injectVar(thisOp);
        }
        if (result == null) {
            StreamOpTranscode newOp = new StreamOpTranscode(op.getTranscoding(), subOp.getStreamOp());
            result = new StreamOpEntry<Location>(newOp, subOp.getValue());
        }
        return result;
    }

    @Override
    public StreamOpEntry<Location> transform(StreamOpContentConvert op, StreamOpEntry<Location> subOp) {
        boolean isSupported;
        StreamOpEntry<Location> result = null;
        if (subOp.getValue() == Location.HANDLED && !(isSupported = false)) {
            StreamOpContentConvert thisOp = new StreamOpContentConvert(op.getSourceFormat(), op.getTargetFormat(), op.getBaseIri(), subOp.getStreamOp());
            result = this.injectVar(thisOp);
        }
        if (result == null) {
            StreamOpContentConvert newOp = new StreamOpContentConvert(op.getSourceFormat(), op.getTargetFormat(), op.getBaseIri(), subOp.getStreamOp());
            result = new StreamOpEntry<Location>(newOp, subOp.getValue());
        }
        return result;
    }

    protected StreamOpEntry<Location> injectVar(StreamOp thisOp) {
        String varName = "v" + this.nextVar++;
        this.varToOp.put(varName, thisOp);
        StreamOpVar v = new StreamOpVar(varName);
        StreamOpEntry<Location> result = new StreamOpEntry<Location>(v, Location.NOT_HANDLED);
        return result;
    }

    @Override
    public StreamOpEntry<Location> transform(StreamOpFile op) {
        return new StreamOpEntry<Location>(op, Location.HANDLED);
    }

    @Override
    public StreamOpEntry<Location> transform(StreamOpVar op) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StreamOpEntry<Location> transform(StreamOpCommand op) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StreamOpEntry<Location> transform(StreamOpConcat op, List<StreamOpEntry<Location>> subOps) {
        throw new UnsupportedOperationException();
    }

    public static enum Location {
        NOT_HANDLED,
        HANDLED;

    }
}

