/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.registry.codec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.aksw.shellgebra.algebra.common.TranscodeMode;
import org.aksw.shellgebra.registry.codec.CodecSpec;
import org.aksw.shellgebra.registry.codec.CodecVariant;
import org.aksw.shellgebra.shim.cmd.JavaCodec;
import org.aksw.shellgebra.shim.cmd.JavaCodecProvider;
import org.aksw.shellgebra.shim.cmd.JavaCodecProviderOverCommonsCompress;
import org.aksw.shellgebra.shim.cmd.JavaStreamTransform;

public class CodecRegistry {
    private Map<String, CodecSpec> registry = new HashMap<String, CodecSpec>();
    private List<JavaCodecProvider> javaCodecProviders = new ArrayList<JavaCodecProvider>();
    private static CodecRegistry defaultRegistry = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CodecRegistry get() {
        if (defaultRegistry != null) return defaultRegistry;
        Class<CodecRegistry> clazz = CodecRegistry.class;
        synchronized (CodecRegistry.class) {
            if (defaultRegistry != null) return defaultRegistry;
            defaultRegistry = new CodecRegistry();
            CodecRegistry.loadDefaults(defaultRegistry);
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultRegistry;
        }
    }

    public Optional<CodecSpec> getCodecSpec(String name) {
        return Optional.ofNullable(this.registry.get(name));
    }

    public List<CodecVariant> getEncoders(String name) {
        List<CodecVariant> result = this.getCodecSpec(name).stream().map(CodecSpec::getEncoderVariants).flatMap(Collection::stream).toList();
        return result;
    }

    public List<CodecVariant> getDecoders(String name) {
        List<CodecVariant> result = this.getCodecSpec(name).stream().map(CodecSpec::getDecoderVariants).flatMap(Collection::stream).toList();
        return result;
    }

    public CodecRegistry add(CodecSpec spec) {
        this.registry.put(spec.getName(), spec);
        return this;
    }

    public static void loadDefaults(CodecRegistry registry) {
        CodecSpec spec = CodecSpec.newBuilder().setName("bzip2").addDecoderVariant(CodecVariant.of("lbzip2", "-cd")).addDecoderVariant(CodecVariant.of("bzip2", "-cd")).addEncoderVariant(CodecVariant.of("lbzip2", "-c")).addEncoderVariant(CodecVariant.of("bzip2", "-c")).build();
        registry.add(spec);
        spec = CodecSpec.newBuilder().setName("gz").addDecoderVariant(CodecVariant.of("gzip", "-cd")).addEncoderVariant(CodecVariant.of("gzip", "-c")).build();
        registry.add(spec);
        registry.addJavaCodecProvider((JavaCodecProvider)new JavaCodecProviderOverCommonsCompress());
    }

    public Optional<JavaStreamTransform> getJavaCodec(String javaName, TranscodeMode mode) {
        Optional<JavaStreamTransform> result = this.javaCodecProviders.stream().map(provider -> provider.getCodec(javaName)).flatMap(Optional::stream).map(codec -> TranscodeMode.DECODE.equals((Object)mode) ? codec.decoder() : codec.encoder()).findFirst();
        return result;
    }

    public Optional<JavaCodec> getJavaCodec(String javaName) {
        Optional<JavaCodec> result = this.javaCodecProviders.stream().map(provider -> provider.getCodec(javaName)).flatMap(Optional::stream).findFirst();
        return result;
    }

    public JavaCodec requireJavaCodec(String javaName) {
        JavaCodec result = this.getJavaCodec(javaName).orElseThrow(() -> new NoSuchElementException(javaName));
        return result;
    }

    public CodecRegistry addJavaCodecProvider(JavaCodecProvider provider) {
        this.javaCodecProviders.add(0, provider);
        return this;
    }
}

