/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.stream.transform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgCmdOp;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgLiteral;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpExec;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpGroup;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpPipeline;
import org.aksw.shellgebra.algebra.stream.op.CodecSysEnv;
import org.aksw.shellgebra.algebra.stream.op.HasStreamOp;
import org.aksw.shellgebra.algebra.stream.op.StreamOp;
import org.aksw.shellgebra.algebra.stream.op.StreamOpCommand;
import org.aksw.shellgebra.algebra.stream.op.StreamOpConcat;
import org.aksw.shellgebra.algebra.stream.op.StreamOpFile;
import org.aksw.shellgebra.algebra.stream.op.StreamOpTranscode;
import org.aksw.shellgebra.algebra.stream.transformer.StreamOpTransformBase;
import org.aksw.shellgebra.exec.SysRuntime;
import org.aksw.shellgebra.registry.codec.CodecRegistry;
import org.aksw.shellgebra.registry.codec.CodecSpec;
import org.aksw.shellgebra.registry.codec.CodecVariant;

public class StreamOpTransformToCmdOp
extends StreamOpTransformBase {
    private CodecRegistry registry;
    private CodecSysEnv env;

    public StreamOpTransformToCmdOp(CodecRegistry registry, CodecSysEnv env) {
        this.registry = registry;
        this.env = env;
    }

    @Override
    public StreamOp transform(StreamOpFile op) {
        throw new UnsupportedOperationException("Cannot tranform file; must be a child of another stream op.");
    }

    @Override
    public StreamOp transform(StreamOpConcat op, List<StreamOp> subOps) {
        HasStreamOp result;
        boolean isPushable = subOps.stream().allMatch(x -> x instanceof StreamOpCommand);
        if (isPushable) {
            List<CmdOp> args = subOps.stream().map(x -> (StreamOpCommand)x).map(StreamOpCommand::getCmdOp).toList();
            result = new StreamOpCommand((CmdOp)new CmdOpGroup(args, List.of()));
        } else {
            result = super.transform(op, (List)subOps);
        }
        return result;
    }

    public static String resolveCmdName(String toolName, SysRuntime runtime) {
        String resolvedCmdName;
        String rawCmdName = toolName;
        try {
            resolvedCmdName = runtime.which(rawCmdName);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        return resolvedCmdName;
    }

    @Override
    public StreamOp transform(StreamOpTranscode op, StreamOp subOp) {
        String name = op.getName();
        StreamOp result = null;
        CodecSpec spec = this.registry.getCodecSpec(name).orElseThrow(() -> new NoSuchElementException("No codec with name: " + name));
        for (CodecVariant variant : spec.getDecoderVariants()) {
            String toolName = variant.getToolName();
            String resolvedCmdName = StreamOpTransformToCmdOp.resolveCmdName(toolName, this.env.getRuntime());
            ArrayList<CmdArgCmdOp> args = new ArrayList<CmdArgCmdOp>();
            variant.getArgs().forEach(s -> args.add((CmdArgCmdOp)new CmdArgLiteral(s)));
            SysRuntime runtime = this.env.getRuntime();
            boolean canSubst = true;
            boolean supportsStdIn = true;
            boolean supportsFile = true;
            if (subOp instanceof StreamOpCommand) {
                CmdOpExec newCmdOp;
                StreamOpCommand subCmd = (StreamOpCommand)subOp;
                CmdOp cmdOp = subCmd.getCmdOp();
                if (supportsStdIn) {
                    newCmdOp = CmdOpExec.of((String)resolvedCmdName, args);
                    newCmdOp = CmdOpPipeline.of((CmdOp[])new CmdOp[]{cmdOp, newCmdOp});
                } else {
                    args.add(new CmdArgCmdOp(cmdOp));
                    newCmdOp = CmdOpExec.of((String)resolvedCmdName, args);
                }
                result = new StreamOpCommand((CmdOp)newCmdOp);
            }
            if (subOp instanceof StreamOpFile) {
                StreamOpFile cmdOfFile = (StreamOpFile)subOp;
                result = new StreamOpCommand((CmdOp)CmdOpExec.ofLiterals((String)"cat", (String[])new String[]{cmdOfFile.getPath()}));
            }
            if (result == null) continue;
            break;
        }
        if (result == null) {
            result = super.transform(op, subOp);
        }
        return result;
    }
}

