/*
 * Decompiled with CFR 0.152.
 */
package to_delete;

import java.io.InputStream;
import java.io.OutputStream;

final class FdEntry
implements AutoCloseable {
    private final int fd;
    private final FdType type;
    private final ClosePolicy closePolicy;
    private final InputStream in;
    private final OutputStream out;

    public FdEntry(int fd, FdType type, ClosePolicy closePolicy, InputStream in, OutputStream out) {
        this.fd = fd;
        this.type = type;
        this.closePolicy = closePolicy;
        this.in = in;
        this.out = out;
    }

    public int getFd() {
        return this.fd;
    }

    public FdType getType() {
        return this.type;
    }

    public ClosePolicy getClosePolicy() {
        return this.closePolicy;
    }

    public InputStream getIn() {
        return this.in;
    }

    public OutputStream getOut() {
        return this.out;
    }

    @Override
    public void close() throws Exception {
        if (this.closePolicy == ClosePolicy.OWNED) {
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static enum FdType {
        IN,
        OUT,
        INOUT;

    }

    public static enum ClosePolicy {
        OWNED,
        BORROWED;

    }
}

