/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.aksw.vshell.registry.ProcessBase;

public class ProcessOverCompletableFuture
extends ProcessBase {
    private CompletableFuture<Integer> asyncComputation;

    public ProcessOverCompletableFuture(CompletableFuture<Integer> asyncComputation) {
        this.asyncComputation = asyncComputation;
    }

    public static Process of(Supplier<Integer> supplier) {
        CompletableFuture<Integer> future = CompletableFuture.supplyAsync(supplier);
        return new ProcessOverCompletableFuture(future);
    }

    @Override
    public int waitFor() throws InterruptedException {
        try {
            int n = this.asyncComputation.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return this.exitValue();
    }

    @Override
    public void destroy() {
        this.asyncComputation.cancel(true);
    }

    @Override
    public int exitValue() {
        if (this.asyncComputation.isDone()) {
            int exitValue;
            try {
                exitValue = this.asyncComputation.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            return exitValue;
        }
        throw new IllegalThreadStateException("Thread has not yet terminated");
    }
}

