/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public abstract class ProcessBase
extends Process {
    private final PipedInputStream stdoutIn = new PipedInputStream();
    private final PipedInputStream stderrIn = new PipedInputStream();
    private final PipedOutputStream stdinOut = new PipedOutputStream();
    private final PipedOutputStream stdoutSink;
    private final PipedOutputStream stderrSink;
    private final PipedInputStream stdinIn;
    private volatile Integer exitValue = null;

    public ProcessBase() {
        try {
            this.stdoutSink = new PipedOutputStream(this.stdoutIn);
            this.stderrSink = new PipedOutputStream(this.stderrIn);
            this.stdinIn = new PipedInputStream(this.stdinOut);
        }
        catch (IOException e) {
            throw new IllegalStateException("Should not happen", e);
        }
    }

    public PipedOutputStream getStdoutSink() {
        return this.stdoutSink;
    }

    public PipedOutputStream getStderrSink() {
        return this.stderrSink;
    }

    public PipedInputStream getStdinIn() {
        return this.stdinIn;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdinOut;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdoutIn;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderrIn;
    }

    protected void setExitValue(Integer exitValue) {
        this.exitValue = exitValue;
    }

    @Override
    public int exitValue() {
        if (this.exitValue == null) {
            throw new IllegalThreadStateException("Thread has not yet terminated");
        }
        return this.exitValue;
    }
}

