/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Objects;
import org.aksw.vshell.registry.Input;
import org.aksw.vshell.registry.Output;

public abstract class InputBase
implements Input {
    private InputStream inputStream;
    private BufferedReader reader = null;
    private Charset readerCharset = null;

    public InputBase(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    protected abstract InputStream openInputStream() throws IOException;

    @Override
    public Charset getReaderCharset() {
        return this.readerCharset;
    }

    @Override
    public boolean hasReader() {
        return this.reader != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream inputStream() {
        InputBase inputBase = this;
        synchronized (inputBase) {
            if (this.inputStream == null) {
                try {
                    this.inputStream = this.openInputStream();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.inputStream;
    }

    @Override
    public final BufferedReader reader() {
        return this.reader(Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final BufferedReader reader(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        InputBase inputBase = this;
        synchronized (inputBase) {
            if (this.reader == null) {
                this.readerCharset = charset;
                this.reader = new BufferedReader(new InputStreamReader(this.inputStream(), charset));
            } else if (!this.readerCharset.equals(charset)) {
                throw new IllegalStateException("BufferedReader was created with charset: " + String.valueOf(this.readerCharset));
            }
            return this.reader;
        }
    }

    @Override
    public final void transferTo(Output output) throws IOException {
        if (this.hasReader()) {
            if (output.hasPrinter()) {
                this.reader().transferTo(new OutputStreamWriter((OutputStream)output.printStream(), output.getWriterCharset()));
            } else {
                this.reader().transferTo(output.writer());
            }
        } else if (output.hasPrinter()) {
            this.reader().transferTo(new OutputStreamWriter((OutputStream)output.printStream(), this.readerCharset));
        } else if (output.hasWriter()) {
            this.reader().transferTo(output.writer());
        } else {
            this.inputStream().transferTo(output.outputStream());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        } else if (this.inputStream != null) {
            this.inputStream.close();
        }
    }
}

