/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.aksw.commons.util.docker.ContainerUtils;
import org.aksw.commons.util.docker.ImageIntrospectorImpl;
import org.aksw.shellgebra.exec.SysRuntimeFactoryDocker;
import org.aksw.shellgebra.exec.SysRuntimeImpl;
import org.aksw.shellgebra.exec.model.ExecSite;
import org.aksw.shellgebra.exec.model.ExecSiteCurrentHost;
import org.aksw.shellgebra.exec.model.ExecSiteCurrentJvm;
import org.aksw.shellgebra.exec.model.ExecSiteDockerImage;
import org.aksw.shellgebra.exec.model.ExecSiteVisitor;
import org.aksw.shellgebra.introspect.ShellProbeResult;
import org.aksw.shellgebra.model.osreo.ImageIntrospector;
import org.aksw.shellgebra.shim.core.JvmCommand;
import org.aksw.vshell.registry.CommandBinding;
import org.aksw.vshell.registry.CommandCatalog;
import org.aksw.vshell.registry.ExecSiteProbeResults;
import org.aksw.vshell.registry.JvmCommandRegistry;
import org.testcontainers.containers.ContainerFetchException;
import org.testcontainers.containers.ContainerLaunchException;

public class ExecSiteResolver {
    private CommandCatalog cmdCatalog;
    private JvmCommandRegistry jvmCmdRegistry;
    private ExecSiteProbeResults cmdAvailability;
    private ImageIntrospector dockerImageIntrospector;

    public ExecSiteResolver(CommandCatalog cmdCatalog, JvmCommandRegistry jvmCmdRegistry, ExecSiteProbeResults cmdAvailability, ImageIntrospector dockerImageIntrospector) {
        this.cmdCatalog = cmdCatalog;
        this.jvmCmdRegistry = jvmCmdRegistry;
        this.cmdAvailability = cmdAvailability;
        this.dockerImageIntrospector = dockerImageIntrospector;
    }

    public static ExecSiteResolver of(CommandCatalog commandCatalog, JvmCommandRegistry jvmCmdRegistry) {
        ImageIntrospector imageIntrospector = ImageIntrospectorImpl.of();
        return new ExecSiteResolver(commandCatalog, jvmCmdRegistry, ExecSiteProbeResults.get(), imageIntrospector);
    }

    public CommandCatalog getCommandCatalog() {
        return this.cmdCatalog;
    }

    public JvmCommandRegistry getJvmCmdRegistry() {
        return this.jvmCmdRegistry;
    }

    public Optional<CommandBinding> resolve(String virtualCmd, ExecSite execSite) {
        CommandBinding result = null;
        Set candLocations = this.cmdCatalog.get(virtualCmd, execSite).orElse(Set.of());
        for (CommandBinding cmdBinding : candLocations) {
            String cmdName = cmdBinding.commandName();
            boolean isPresent = this.providesCommand(cmdName, execSite);
            if (!isPresent) continue;
            result = cmdBinding;
            break;
        }
        return Optional.ofNullable(result);
    }

    public Map<ExecSite, CommandBinding> resolve(String virtualCmd) {
        LinkedHashMap<ExecSite, CommandBinding> result = new LinkedHashMap<ExecSite, CommandBinding>();
        Map map = this.cmdCatalog.get(virtualCmd).asMap();
        for (Map.Entry e : map.entrySet()) {
            ExecSite execSite = (ExecSite)e.getKey();
            for (CommandBinding cmdBinding : (Collection)e.getValue()) {
                String cmdName = cmdBinding.commandName();
                boolean isPresent = this.providesCommand(cmdName, execSite);
                if (!isPresent) continue;
                result.put((ExecSite)e.getKey(), cmdBinding);
            }
        }
        return result;
    }

    public boolean canRunPipeline(ExecSite execSite) {
        return execSite.accept(new ExecSiteVisitor<Boolean>(this){

            @Override
            public Boolean visit(ExecSiteDockerImage execSite) {
                ShellProbeResult probeResult = SysRuntimeFactoryDocker.get().findShell(execSite.imageRef(), true, "bash");
                return probeResult != null;
            }

            @Override
            public Boolean visit(ExecSiteCurrentHost execSite) {
                return true;
            }

            @Override
            public Boolean visit(ExecSiteCurrentJvm execSite) {
                return true;
            }
        });
    }

    public boolean providesCommand(final String command, ExecSite execSite) {
        return execSite.accept(new ExecSiteVisitor<Boolean>(){
            final /* synthetic */ ExecSiteResolver this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Boolean visit(ExecSiteDockerImage execSite) {
                String imageRef = execSite.imageRef();
                List commandPrefix = null;
                String entrypoint = null;
                Boolean r = this.this$0.cmdAvailability.get(command, (ExecSite)execSite);
                if (r == null) {
                    ShellProbeResult probeResult = SysRuntimeFactoryDocker.get().findShell(execSite.imageRef(), true, "bash");
                    if (probeResult != null) {
                        entrypoint = probeResult.location();
                        commandPrefix = Optional.ofNullable(probeResult.commandOption()).map(List::of).orElse(List.of());
                    }
                    try {
                        r = ContainerUtils.hasCommand(imageRef, entrypoint, commandPrefix, command);
                    }
                    catch (ContainerFetchException | ContainerLaunchException e) {
                        r = false;
                    }
                    this.this$0.cmdAvailability.put(command, (ExecSite)execSite, (boolean)r);
                }
                return r;
            }

            @Override
            public Boolean visit(ExecSiteCurrentHost execSite) {
                Boolean r;
                boolean doCache = false;
                Boolean bl = r = doCache ? this.this$0.cmdAvailability.get(command, (ExecSite)execSite) : null;
                if (r == null) {
                    String path = null;
                    try {
                        path = SysRuntimeImpl.forCurrentOs().which(command);
                    }
                    catch (IOException | InterruptedException exception) {
                        // empty catch block
                    }
                    r = path != null;
                    if (doCache) {
                        this.this$0.cmdAvailability.put(command, (ExecSite)execSite, (boolean)r);
                    }
                }
                return r;
            }

            @Override
            public Boolean visit(ExecSiteCurrentJvm execSite) {
                Optional<JvmCommand> jvmCmd = this.this$0.jvmCmdRegistry.get(command);
                return jvmCmd.isPresent();
            }
        });
    }
}

