/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.util.Optional;
import java.util.Set;
import org.aksw.shellgebra.exec.model.ExecSites;
import org.aksw.shellgebra.shim.core.JvmCommandParser;
import org.aksw.vshell.registry.CommandCatalog;
import org.aksw.vshell.registry.CommandParserCatalog;
import org.aksw.vshell.registry.JvmCommandRegistry;

public class CommandParserCatalogImpl
implements CommandParserCatalog {
    private CommandCatalog commandCatalog;
    private JvmCommandRegistry commandRegistry;

    public CommandParserCatalogImpl(CommandCatalog commandCatalog, JvmCommandRegistry commandRegistry) {
        this.commandCatalog = commandCatalog;
        this.commandRegistry = commandRegistry;
    }

    @Override
    public Optional<JvmCommandParser> getParser(String commandName) {
        JvmCommandParser parser = null;
        Set cands = this.commandCatalog.get(commandName, ExecSites.jvm()).orElse(null);
        if (cands != null) {
            parser = cands.stream().flatMap(c -> this.commandRegistry.get(c.commandName()).stream()).findFirst().orElse(null);
        }
        return Optional.ofNullable(parser);
    }
}

