/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.aksw.shellgebra.exec.model.ExecSite;
import org.aksw.vshell.registry.CommandBinding;
import org.aksw.vshell.registry.CommandBindingLocator;
import org.aksw.vshell.registry.CommandBindingLocatorOverCommandLocator;
import org.aksw.vshell.registry.CommandCatalog;
import org.aksw.vshell.registry.CommandLocator;

public class CommandCatalogOverLocator
implements CommandCatalog {
    private ExecSite execSite;
    private CommandBindingLocator locator;

    public CommandCatalogOverLocator(ExecSite execSite, CommandLocator locator) {
        this(execSite, CommandBindingLocatorOverCommandLocator.of(locator));
    }

    public CommandCatalogOverLocator(ExecSite execSite, CommandBindingLocator locator) {
        this.execSite = execSite;
        this.locator = Objects.requireNonNull(locator);
    }

    @Override
    public Multimap<ExecSite, CommandBinding> get(String virtualCommandName) {
        Optional<CommandBinding> match = this.locator.locate(virtualCommandName);
        Map map = match.map(str -> Map.of(this.execSite, str)).orElse(Map.of());
        return Multimaps.forMap(map);
    }
}

