/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.aksw.shellgebra.algebra.cmd.transform.FileMapper;
import org.aksw.shellgebra.exec.ListBuilder;
import org.aksw.shellgebra.exec.model.ExecSite;
import org.aksw.shellgebra.exec.model.ExecSiteDockerImage;
import org.aksw.shellgebra.exec.model.ExecSites;
import org.aksw.shellgebra.processbuilder.IProcessBuilderCore;
import org.aksw.shellgebra.processbuilder.ProcessBuilderDocker;
import org.aksw.shellgebra.shim.core.JvmCommandParser;
import org.aksw.vshell.registry.CmdOpVisitorToBase;
import org.aksw.vshell.registry.CommandBinding;
import org.aksw.vshell.registry.CommandCatalog;
import org.aksw.vshell.registry.ExecSiteToProcessDispatcher;
import org.aksw.vshell.registry.JvmCommandRegistry;

public class CmdOpVisitorToPbDocker
extends CmdOpVisitorToBase {
    protected ExecSiteDockerImage execSite;

    public CmdOpVisitorToPbDocker(ExecSiteToProcessDispatcher dispatcher, ExecSiteDockerImage execSite) {
        super(dispatcher);
        this.execSite = execSite;
    }

    @Override
    protected IProcessBuilderCore<?> toProcessBuilder(List<String> args) {
        ExecSiteToProcessDispatcher dispatcher = this.getDispatcher();
        String commandName = args.get(0);
        CommandCatalog commandCatalog = dispatcher.getCommandCatalog();
        JvmCommandRegistry commandRegistry = dispatcher.getJvmCmdRegistry();
        JvmCommandParser parser = null;
        Set parserCands = commandCatalog.get(commandName, ExecSites.jvm()).orElse(null);
        CommandBinding parserCand = null;
        if (parserCands != null) {
            for (CommandBinding cmdBinding : parserCands) {
                String cmdName = cmdBinding.commandName();
                parser = commandRegistry.get(cmdName).orElse(null);
                if (parser == null) continue;
                parserCand = cmdBinding;
                break;
            }
        }
        if (parser == null) {
            throw new RuntimeException("No command parser found for: " + commandName);
        }
        List<String> newArgv = CmdOpVisitorToPbDocker.resolveOrFail(commandCatalog, commandName, this.execSite, args);
        String imageRef = this.execSite.imageRef();
        FileMapper fileMapper = dispatcher.getFileMapper();
        ProcessBuilderDocker result = ProcessBuilderDocker.of(newArgv).commandParser(parser).imageRef(imageRef).fileMapper(fileMapper);
        return result;
    }

    public static CommandBinding resolveOrFail(CommandCatalog commandCatalog, String commandName, ExecSite execSite) {
        Set<CommandBinding> nameCands = commandCatalog.get(commandName, execSite).orElseThrow(() -> new RuntimeException("command " + commandName + " not found on exec site " + String.valueOf(execSite)));
        if (nameCands.isEmpty()) {
            throw new RuntimeException("Command " + commandName + " does not have resolutions on exec site " + String.valueOf(execSite));
        }
        CommandBinding resolvedName = nameCands.iterator().next();
        return resolvedName;
    }

    public static List<String> resolveOrFail(CommandCatalog commandCatalog, String commandName, ExecSite execSite, List<String> args) {
        CommandBinding commandBinding = CmdOpVisitorToPbDocker.resolveOrFail(commandCatalog, commandName, execSite);
        List<String> newArgs = commandBinding.argsTransform().map(args);
        List<String> newArgv = ListBuilder.ofString().add(commandBinding.commandName()).addAll((Collection<String>)newArgs).buildList();
        return newArgv;
    }
}

