/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.aksw.commons.util.docker.ImageIntrospectorImpl;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.transform.FileMapper;
import org.aksw.shellgebra.exec.graph.ProcessRunner;
import org.aksw.shellgebra.exec.model.ExecSite;
import org.aksw.shellgebra.exec.model.ExecSiteCurrentHost;
import org.aksw.shellgebra.exec.model.ExecSites;
import org.aksw.shellgebra.exec.model.PlacedCommand;
import org.aksw.shellgebra.model.osreo.ImageIntrospector;
import org.aksw.shellgebra.registry.init.InitCommandRegistry;
import org.aksw.vshell.registry.CandidatePlacement;
import org.aksw.vshell.registry.CmdOpVisitorCandidatePlacer;
import org.aksw.vshell.registry.CommandCatalog;
import org.aksw.vshell.registry.CommandCatalogOverLocator;
import org.aksw.vshell.registry.CommandCatalogUnion;
import org.aksw.vshell.registry.CommandLocatorHost;
import org.aksw.vshell.registry.CommandLocatorJvmRegistry;
import org.aksw.vshell.registry.CommandRegistry;
import org.aksw.vshell.registry.ExecSiteProbeResults;
import org.aksw.vshell.registry.ExecSiteResolver;
import org.aksw.vshell.registry.FinalPlacement;
import org.aksw.vshell.registry.FinalPlacementInliner;
import org.aksw.vshell.registry.FinalPlacer;
import org.aksw.vshell.registry.JvmCommandRegistry;
import org.aksw.vshell.registry.ProcessBuilderFinalPlacement;

public class CmdExecSystem {
    private JvmCommandRegistry jvmCmdRegistry;
    private CommandRegistry candidates;
    private CommandRegistry inferredCatalog;
    private CommandCatalog hostCatalog;
    private CommandCatalog jvmCatalog;
    private CommandCatalog unionCatalog;
    private ExecSiteProbeResults probeResults;
    private ImageIntrospector imageIntrospector;
    private ExecSiteResolver resolver;

    public CmdExecSystem() {
        this.init();
    }

    public void init() {
        this.jvmCmdRegistry = InitCommandRegistry.initJvmCmdRegistry(new JvmCommandRegistry());
        this.candidates = InitCommandRegistry.initCmdCandRegistry(new CommandRegistry());
        this.inferredCatalog = new CommandRegistry();
        this.hostCatalog = new CommandCatalogOverLocator((ExecSite)ExecSiteCurrentHost.get(), new CommandLocatorHost());
        this.jvmCatalog = new CommandCatalogOverLocator(ExecSites.jvm(), new CommandLocatorJvmRegistry(this.jvmCmdRegistry));
        this.unionCatalog = new CommandCatalogUnion(List.of(this.candidates, this.hostCatalog, this.jvmCatalog, this.inferredCatalog));
        this.probeResults = new ExecSiteProbeResults();
        this.imageIntrospector = ImageIntrospectorImpl.of();
        this.resolver = new ExecSiteResolver(this.candidates, this.jvmCmdRegistry, this.probeResults, this.imageIntrospector);
    }

    public JvmCommandRegistry getJvmCmdRegistry() {
        return this.jvmCmdRegistry;
    }

    public CommandRegistry getCandidates() {
        return this.candidates;
    }

    public CommandRegistry getInferredCatalog() {
        return this.inferredCatalog;
    }

    public CommandCatalog getHostCatalog() {
        return this.hostCatalog;
    }

    public CommandCatalog getJvmCatalog() {
        return this.jvmCatalog;
    }

    public CommandCatalog getUnionCatalog() {
        return this.unionCatalog;
    }

    public ExecSiteResolver getResolver() {
        return this.resolver;
    }

    public FinalPlacement rewrite(CmdOp cmdOp, ExecSite preferredExecSite) {
        Set<ExecSite> preferredExecSites = Set.of(preferredExecSite);
        FinalPlacement result = this.rewrite(cmdOp, preferredExecSites);
        return result;
    }

    public FinalPlacement rewrite(CmdOp cmdOp, Set<ExecSite> preferredExecSites) {
        CmdOpVisitorCandidatePlacer commandPlacer = new CmdOpVisitorCandidatePlacer(this.candidates, this.inferredCatalog, this.resolver, preferredExecSites);
        PlacedCommand placedCommand = cmdOp.accept(commandPlacer);
        CandidatePlacement candidatePlacement = new CandidatePlacement(placedCommand, commandPlacer.getVarToPlacement());
        System.out.println("Candidate Placement: " + String.valueOf(candidatePlacement));
        FinalPlacement placed = FinalPlacer.place(candidatePlacement);
        System.out.println("Placed: " + String.valueOf(placed));
        FinalPlacement inlined = FinalPlacementInliner.inline(placed);
        return inlined;
    }

    public Process exec(ProcessRunner execCxt, FileMapper fileMapper, CmdOp cmdOp, ExecSite preferredExecSite) throws IOException {
        FinalPlacement finalPlacement = this.rewrite(cmdOp, preferredExecSite);
        ProcessBuilderFinalPlacement pb = new ProcessBuilderFinalPlacement(fileMapper, this.resolver, this.unionCatalog);
        pb.command(finalPlacement);
        Process p = pb.start(execCxt);
        return p;
    }
}

