/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.shim.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ArgsBuilder {
    private final List<String> args = new ArrayList<String>();

    public ArgsBuilder opt(String name, String value) {
        Objects.requireNonNull(name);
        if (value != null) {
            this.args.add(name);
            this.args.add(value);
        }
        return this;
    }

    public ArgsBuilder ifTrue(boolean value, String arg) {
        Objects.requireNonNull(arg);
        if (value) {
            this.args.add(arg);
        }
        return this;
    }

    public ArgsBuilder arg(String value) {
        if (value != null) {
            this.args.add(value);
        }
        return this;
    }

    public ArgsBuilder fileOrLiteral(String filename, String fallbackLiteral) {
        Objects.requireNonNull(fallbackLiteral);
        if (filename != null) {
            this.args.add(filename);
        } else {
            this.args.add(fallbackLiteral);
        }
        return this;
    }

    public ArgsBuilder arg(String value, String fallback) {
        if (value != null) {
            this.args.add(value);
        } else if (fallback != null) {
            this.args.add(fallback);
        }
        return this;
    }

    public ArgsBuilder args(List<String> list) {
        if (list != null) {
            for (String item : list) {
                this.args.add(item);
            }
        }
        return this;
    }

    public ArgsBuilder files(List<String> list) {
        if (list != null) {
            for (String item : list) {
                this.args.add(item);
            }
        }
        return this;
    }

    public List<String> build() {
        return new ArrayList<String>(this.args);
    }

    public static ArgsBuilder newBuilder() {
        return new ArgsBuilder();
    }
}

