/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.shim.cmd;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.aksw.shellgebra.shim.core.Args;
import org.aksw.shellgebra.shim.core.ArgsModular;
import org.aksw.shellgebra.shim.core.ArgumentList;
import org.aksw.shellgebra.shim.core.ArgumentListBuilder;
import org.aksw.shellgebra.shim.picocli.ArgsParserPicocli;
import picocli.CommandLine;

public class GenericCodecArgs
implements Args {
    @CommandLine.Option(names={"-d", "--decompress"}, description={"Decompress"})
    boolean decode;
    @CommandLine.Option(names={"-c", "--stdout"}, description={"Output to console."})
    boolean stdout;
    @CommandLine.Parameters(arity="0..*", description={"File names"})
    public List<String> fileNames = new ArrayList<String>();
    @CommandLine.Unmatched
    List<String> unmatchedArgs = new ArrayList<String>();

    public List<String> getFileNames() {
        return this.fileNames;
    }

    public boolean isDecode() {
        return this.decode;
    }

    public boolean isStdout() {
        return this.stdout;
    }

    public List<String> getUnmatchedArgs() {
        return this.unmatchedArgs;
    }

    public String toString() {
        return "GenericCodecArgs [decode=" + this.decode + ", unmatchedArgs=" + String.valueOf(this.unmatchedArgs) + "]";
    }

    @Override
    public ArgumentList toArgList() {
        return GenericCodecArgs.renderArgList(this);
    }

    public static ArgumentList renderArgList(GenericCodecArgs model) {
        ArgumentList result = ArgumentListBuilder.newBuilder().ifTrue(model.isDecode(), "-d").ifTrue(model.isStdout(), "-c").files(model.getFileNames()).args(model.getUnmatchedArgs()).build();
        return result;
    }

    public static Boolean stdinTest(GenericCodecArgs model) {
        return model.readsStdin().orElse(null);
    }

    public static ArgsModular<GenericCodecArgs> parse(String[] args) {
        GenericCodecArgs model = ArgsParserPicocli.of(GenericCodecArgs::new).parse(args);
        return new ArgsModular<GenericCodecArgs>(model, GenericCodecArgs::renderArgList, GenericCodecArgs::stdinTest);
    }

    @Override
    public Optional<Boolean> readsStdin() {
        boolean result = this.fileNames.isEmpty() || this.fileNames.contains("-");
        return Optional.of(result);
    }
}

