/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.processbuilder;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.aksw.shellgebra.exec.graph.JRedirect;
import org.aksw.shellgebra.exec.graph.PathResource;
import org.aksw.shellgebra.exec.graph.ProcessRunner;
import org.aksw.shellgebra.io.pipe.NamedPipe;
import org.aksw.shellgebra.io.pipe.PosixPipe;
import org.aksw.shellgebra.processbuilder.IProcessBuilderCore;
import org.aksw.shellgebra.processbuilder.ProcessBuilderCompound;
import org.aksw.shellgebra.processbuilder.ProcessPipeline;
import org.aksw.shellgebra.util.PathLifeCycle;
import org.aksw.shellgebra.util.PathLifeCycles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessBuilderPipeline
extends ProcessBuilderCompound<ProcessBuilderPipeline> {
    private static final Logger logger = LoggerFactory.getLogger(ProcessBuilderPipeline.class);

    @Override
    public boolean supportsAnonPipeRead() {
        List<IProcessBuilderCore<?>> pbs = this.processBuilders();
        IProcessBuilderCore<?> first = pbs.get(0);
        return first.supportsAnonPipeRead();
    }

    @Override
    public boolean accessesStdIn() {
        List<IProcessBuilderCore<?>> pbs = this.processBuilders();
        IProcessBuilderCore<?> first = pbs.get(0);
        return first.accessesStdIn();
    }

    @Override
    public boolean supportsDirectNamedPipe() {
        List<IProcessBuilderCore<?>> pbs = this.processBuilders();
        IProcessBuilderCore<?> first = pbs.get(0);
        return first.supportsDirectNamedPipe();
    }

    @Override
    public boolean supportsAnonPipeWrite() {
        List<IProcessBuilderCore<?>> pbs = this.processBuilders();
        IProcessBuilderCore<?> last = pbs.get(pbs.size() - 1);
        return last.supportsAnonPipeWrite();
    }

    public static ProcessBuilderPipeline of(IProcessBuilderCore<?> ... processBuilders) {
        return (ProcessBuilderPipeline)new ProcessBuilderPipeline().processBuilders(processBuilders);
    }

    public static ProcessBuilderPipeline of(List<? extends IProcessBuilderCore<?>> processBuilders) {
        return (ProcessBuilderPipeline)new ProcessBuilderPipeline().processBuilders(processBuilders);
    }

    @Override
    protected ProcessBuilderPipeline cloneActual() {
        return new ProcessBuilderPipeline();
    }

    @Override
    public Process start(ProcessRunner executor) throws IOException {
        List<IProcessBuilderCore<?>> pbs = this.copyProcessBuilders();
        int n = pbs.size();
        if (n == 0) {
            throw new IllegalStateException("Pipeline must have at least one member.");
        }
        Path priorPath = null;
        Object priorBuilder = null;
        Callable<Object> thisWriteEnd = null;
        Callable<Object> nextReadEnd = null;
        Callable<Object> prevReadEnd = null;
        ArrayList<CompletableFuture<Process>> processFutures = new ArrayList<CompletableFuture<Process>>(n);
        ArrayList<PathResource> pipes = new ArrayList<PathResource>(n - 1);
        PathLifeCycle namedPipeLifeCycle = PathLifeCycles.deleteAfterExec(PathLifeCycles.namedPipe());
        ExecutorService executorService = Executors.newCachedThreadPool();
        for (int i = 0; i < n; ++i) {
            IProcessBuilderCore<?> next;
            boolean isLast = i == n - 1;
            IProcessBuilderCore<?> currentBuilderPrototype = pbs.get(i);
            Object current = currentBuilderPrototype.clone();
            IProcessBuilderCore<?> iProcessBuilderCore = next = isLast ? null : pbs.get(i + 1);
            if (priorPath == null) {
                current.redirectInput(new JRedirect.JRedirectJava(ProcessBuilder.Redirect.INHERIT));
            } else {
                current.redirectInput(new JRedirect.JRedirectJava(ProcessBuilder.Redirect.from(priorPath.toFile())));
            }
            if (isLast) {
                current.redirectOutput(this.redirectOutput());
            } else {
                PathResource thisPath;
                boolean useNamedPipe;
                boolean thisSupportsNamedPipeOutput = current.supportsDirectNamedPipe();
                boolean nextRequiresNamedPipeInput = next.supportsDirectNamedPipe() && !next.supportsAnonPipeRead();
                boolean nextAccessesStdin = next.accessesStdIn();
                boolean thisRequiresNamedPipeOutput = current.supportsDirectNamedPipe() && !current.supportsAnonPipeWrite();
                boolean nextSupportsNamedPipeInput = next.supportsDirectNamedPipe();
                boolean useNamedPipe1 = thisRequiresNamedPipeOutput && nextSupportsNamedPipeInput;
                boolean useNamedPipe2 = thisSupportsNamedPipeOutput && nextRequiresNamedPipeInput;
                boolean bl = useNamedPipe = useNamedPipe1 || useNamedPipe2;
                if (useNamedPipe) {
                    Path namedPipePath = NamedPipe.newNamedPipePath();
                    thisPath = new PathResource(namedPipePath, namedPipeLifeCycle);
                    thisPath.open();
                    current.redirectOutput(new JRedirect.JRedirectJava(ProcessBuilder.Redirect.to(thisPath.getPath().toFile())));
                    priorPath = thisPath.getPath();
                    thisWriteEnd = () -> {
                        thisPath.close();
                        return null;
                    };
                    boolean doesNotAccessStdIn = next == null || !next.accessesStdIn();
                    nextReadEnd = () -> {
                        InputStream unused;
                        if (doesNotAccessStdIn && (unused = Files.newInputStream(namedPipePath, new OpenOption[0])) != null) {
                            unused.close();
                        }
                        return null;
                    };
                } else {
                    PosixPipe pipe = PosixPipe.open();
                    thisPath = new PathResource(pipe.getWriteEndProcPath(), PathLifeCycles.none());
                    current.redirectOutput(new JRedirect.JRedirectJava(ProcessBuilder.Redirect.to(thisPath.getPath().toFile())));
                    priorPath = pipe.getReadEndProcPath();
                    thisWriteEnd = () -> {
                        System.out.println("Closing write FD: " + pipe.getWriteFd());
                        pipe.getOutputStream().close();
                        return null;
                    };
                    nextReadEnd = () -> {
                        System.out.println("Closing read FD: " + pipe.getReadFd());
                        pipe.getInputStream().close();
                        return null;
                    };
                    logger.info("Created anonymous pipe, ReadFD=" + pipe.getReadFd() + " WriteFD=" + pipe.getWriteFd());
                }
                pipes.add(thisPath);
                priorBuilder = current;
            }
            current.redirectError(this.redirectError());
            Callable<Object> thisWriteEndCloser = thisWriteEnd;
            Callable<Object> thisReadEndCloser = prevReadEnd;
            Supplier<Process> processSupplier = () -> {
                try {
                    Process r = current.start(executor);
                    r.waitFor();
                    Process process = r;
                    return process;
                }
                catch (IOException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    block23: {
                        try {
                            if (thisReadEndCloser == null) break block23;
                            try {
                                thisReadEndCloser.call();
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                        finally {
                            if (thisWriteEndCloser != null) {
                                try {
                                    thisWriteEndCloser.call();
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        }
                    }
                }
            };
            CompletableFuture<Process> processFuture = CompletableFuture.supplyAsync(processSupplier, executorService);
            processFutures.add(processFuture);
            prevReadEnd = nextReadEnd;
        }
        List processes = (List)((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])processFutures.toArray(CompletableFuture[]::new)).thenApply(v -> processFutures.stream().map(CompletableFuture::join).toList())).join();
        executorService.shutdown();
        return new ProcessPipeline(processes, pipes);
    }

    public String toString() {
        return "ProcessBuilderPipeline [processBuilders()=" + String.valueOf(this.processBuilders()) + ", environment()=" + String.valueOf(this.environment()) + ", directory()=" + String.valueOf(this.directory()) + "]";
    }
}

