/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.processbuilder;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.aksw.shellgebra.exec.graph.JRedirect;
import org.aksw.shellgebra.exec.graph.ProcessRunner;
import org.aksw.shellgebra.io.pipe.NamedPipe;
import org.aksw.shellgebra.io.pipe.PosixPipe;
import org.aksw.shellgebra.processbuilder.IProcessBuilderCore;
import org.aksw.shellgebra.processbuilder.PathAndProcess;
import org.aksw.shellgebra.processbuilder.ProcessBuilderCompound;
import org.aksw.shellgebra.processbuilder.ProcessBuilderDocker;
import org.aksw.vshell.registry.ProcessOverCompletableFuture;

public class ProcessBuilderGroup
extends ProcessBuilderCompound<ProcessBuilderGroup> {
    public static ProcessBuilderGroup of(IProcessBuilderCore<?> ... processBuilders) {
        return (ProcessBuilderGroup)new ProcessBuilderGroup().processBuilders(processBuilders);
    }

    public static ProcessBuilderGroup of(List<? extends IProcessBuilderCore<?>> processBuilders) {
        return (ProcessBuilderGroup)new ProcessBuilderGroup().processBuilders(processBuilders);
    }

    @Override
    protected ProcessBuilderGroup cloneActual() {
        return new ProcessBuilderGroup();
    }

    @Override
    public Process start(ProcessRunner executor) throws IOException {
        List<IProcessBuilderCore<?>> pbs = this.copyProcessBuilders();
        CompletableFuture<Integer> future = CompletableFuture.supplyAsync(() -> this.run(executor, pbs));
        return new ProcessOverCompletableFuture(future);
    }

    private PathAndProcess processInput(Path inputPipePath, JRedirect redirect, boolean requiresAnonPipe) throws IOException {
        Path rawInputPath = null;
        if (redirect instanceof JRedirect.JRedirectJava) {
            JRedirect.JRedirectJava x = (JRedirect.JRedirectJava)redirect;
            ProcessBuilder.Redirect r = x.redirect();
            switch (r.type()) {
                case INHERIT: {
                    rawInputPath = inputPipePath;
                    break;
                }
                case READ: {
                    rawInputPath = r.file().toPath();
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported or not implemented yet.");
                }
            }
        }
        boolean isProbablyNamedPipe = ProcessBuilderGroup.isProbablyNamedPipe(rawInputPath);
        Path resultPath = null;
        Process pumpProcess = null;
        if (isProbablyNamedPipe && requiresAnonPipe) {
            PosixPipe anonPipe = PosixPipe.open();
            pumpProcess = ProcessBuilderDocker.catProcess(rawInputPath, anonPipe.getWriteEndProcPath());
            resultPath = anonPipe.getReadEndProcPath();
        } else {
            resultPath = rawInputPath;
        }
        return new PathAndProcess(resultPath, pumpProcess);
    }

    private PathAndProcess processOutput(Path outputPipePath, JRedirect redirect, boolean requiresAnonPipe) throws IOException {
        Path rawPath = null;
        if (redirect instanceof JRedirect.JRedirectJava) {
            JRedirect.JRedirectJava x = (JRedirect.JRedirectJava)redirect;
            ProcessBuilder.Redirect r = x.redirect();
            switch (r.type()) {
                case INHERIT: {
                    rawPath = outputPipePath;
                    break;
                }
                case WRITE: {
                    rawPath = r.file().toPath();
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported or not implemented yet.");
                }
            }
        }
        boolean isProbablyNamedPipe = ProcessBuilderGroup.isProbablyNamedPipe(rawPath);
        Path resultPath = null;
        Process pumpProcess = null;
        PosixPipe closeAction = null;
        if (isProbablyNamedPipe && requiresAnonPipe) {
            PosixPipe anonPipe = PosixPipe.open();
            pumpProcess = ProcessBuilderDocker.catProcess(anonPipe.getReadEndProcPath(), rawPath);
            resultPath = anonPipe.getWriteEndProcPath();
            closeAction = anonPipe;
        } else {
            resultPath = rawPath;
        }
        return new PathAndProcess(resultPath, pumpProcess, closeAction);
    }

    private static boolean isProbablyNamedPipe(Path p) throws IOException {
        if (!Files.exists(p, new LinkOption[0])) {
            return false;
        }
        boolean result = NamedPipe.isNamedPipe(p, true);
        return result;
    }

    private int run(ProcessRunner runner, Collection<? extends IProcessBuilderCore<?>> processBuilders) {
        try {
            return this.runCore(runner, processBuilders);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int runCore(ProcessRunner runner, Collection<? extends IProcessBuilderCore<?>> processBuilders) throws IOException {
        Set<Process> runningProcesses = Collections.synchronizedSet(new LinkedHashSet(processBuilders.size()));
        int result = 0;
        boolean requiresAnonPipeIn = this.processBuilders().stream().filter(member -> member.accessesStdIn()).count() > 1L;
        boolean requiresAnonPipeOutAndErr = this.processBuilders().size() > 1;
        PathAndProcess inProcess = this.processInput(runner.inputPipe(), this.redirectInput(), requiresAnonPipeIn);
        PathAndProcess outProcess = this.processOutput(runner.outputPipe(), this.redirectOutput(), requiresAnonPipeOutAndErr);
        PathAndProcess errProcess = this.processOutput(runner.errorPipe(), this.redirectError(), requiresAnonPipeOutAndErr);
        for (IProcessBuilderCore<?> pb : processBuilders) {
            int exitValue;
            Process process;
            pb.redirectInput(new JRedirect.JRedirectJava(ProcessBuilder.Redirect.from(inProcess.path().toFile())));
            pb.redirectOutput(new JRedirect.JRedirectJava(ProcessBuilder.Redirect.to(outProcess.path().toFile())));
            pb.redirectError(new JRedirect.JRedirectJava(ProcessBuilder.Redirect.to(errProcess.path().toFile())));
            try {
                System.out.println("Process started from: " + String.valueOf(pb));
                process = pb.start(runner);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            runningProcesses.add(process);
            try {
                exitValue = process.waitFor();
                System.out.println("Process finished from: " + String.valueOf(pb));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            result = exitValue;
            runningProcesses.remove(process);
        }
        inProcess.close();
        outProcess.close();
        errProcess.close();
        return result;
    }

    @Override
    public boolean supportsAnonPipeRead() {
        boolean result = this.processBuilders().stream().allMatch(IProcessBuilderCore::supportsAnonPipeRead);
        return result;
    }

    @Override
    public boolean supportsAnonPipeWrite() {
        boolean result = this.processBuilders().stream().allMatch(IProcessBuilderCore::supportsAnonPipeWrite);
        return result;
    }

    @Override
    public boolean supportsDirectNamedPipe() {
        boolean result = this.processBuilders().stream().filter(IProcessBuilderCore::supportsDirectNamedPipe).count() <= 1L;
        return result;
    }

    @Override
    public boolean accessesStdIn() {
        boolean result = this.processBuilders().stream().anyMatch(IProcessBuilderCore::accessesStdIn);
        return result;
    }
}

