/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.stage;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.aksw.commons.io.util.stream.InputStreamTransform;
import org.aksw.commons.io.util.stream.OutputStreamTransform;
import org.aksw.commons.util.docker.ContainerPathResolver;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVar;
import org.aksw.shellgebra.algebra.cmd.transform.FileMapper;
import org.aksw.shellgebra.exec.stage.Stage;
import org.aksw.shellgebra.exec.stage.StageDocker;
import org.aksw.shellgebra.exec.stage.StageHost;
import org.aksw.shellgebra.exec.stage.StageJvm;
import org.aksw.shellgebra.exec.stage.StagePipeline;
import org.aksw.vshell.registry.CmdOpVisitorExecJvm;
import org.aksw.vshell.registry.CommandRegistry;
import org.aksw.vshell.registry.ExecSiteResolver;
import org.aksw.vshell.registry.JvmCommandRegistry;

public class Stages {
    public static Stage pipeline(Stage ... stages) {
        return Stages.pipeline(Arrays.asList(stages));
    }

    public static Stage pipeline(List<Stage> stages) {
        return new StagePipeline(stages);
    }

    public static Stage host(CmdOp cmdOp) {
        return new StageHost(cmdOp);
    }

    public static Stage docker(String imageRef, CmdOp cmdOp, FileMapper fileMapper) {
        return Stages.docker(imageRef, cmdOp, fileMapper, null);
    }

    public static Stage docker(String imageRef, CmdOp cmdOp, FileMapper fileMapper, Function<CmdOpVar, Stage> varResolver) {
        ContainerPathResolver containerPathResolver = ContainerPathResolver.create();
        return new StageDocker(imageRef, cmdOp, fileMapper, containerPathResolver, varResolver);
    }

    public static Stage jvm(JvmCommandRegistry jvmCmdRegistry, CmdOp cmdOp) {
        CommandRegistry cmdAvailability = new CommandRegistry();
        ExecSiteResolver execSiteResolver = ExecSiteResolver.of(cmdAvailability, jvmCmdRegistry);
        CmdOpVisitorExecJvm execVisitor = new CmdOpVisitorExecJvm(execSiteResolver, null);
        Stage result = cmdOp.accept(execVisitor);
        return result;
    }

    public static Stage jvm(CmdOp cmdOp) {
        JvmCommandRegistry jvmCmdRegistry = JvmCommandRegistry.get();
        Stage result = Stages.jvm(jvmCmdRegistry, cmdOp);
        return result;
    }

    public static Stage javaIn(InputStreamTransform transform) {
        return new StageJvm(transform);
    }

    public static Stage javaOut(OutputStreamTransform transform) {
        return Stages.javaIn(transform.asInputStreamTransform());
    }
}

