/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.stage;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Arrays;
import org.aksw.shellgebra.exec.stage.FileWriterTaskViaExecutor;
import org.aksw.shellgebra.util.PathLifeCycle;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWriterTaskFromProcess
extends FileWriterTaskViaExecutor {
    private static final Logger logger = LoggerFactory.getLogger(FileWriterTaskFromProcess.class);
    private DefaultExecutor executor;
    private CommandLine cmdLine;

    public FileWriterTaskFromProcess(Path outputPath, PathLifeCycle pathLifeCycle, String ... cmd) {
        super(outputPath, pathLifeCycle);
        String execCmdStr = cmd[0];
        String[] cmdArgs = Arrays.copyOfRange(cmd, 1, cmd.length);
        this.cmdLine = new CommandLine(execCmdStr);
        this.cmdLine.addArguments(cmdArgs, false);
    }

    protected final void beforeExec() throws IOException {
        this.pathLifeCycle.beforeExec(this.outputPath);
    }

    @Override
    protected void prepareWriteFile() throws IOException {
        LogOutputStream logOutputStream = new LogOutputStream(this){

            protected void processLine(String line, int logLevel) {
                logger.warn(line);
            }
        };
        this.executor = DefaultExecutor.builder().get();
        this.executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)logOutputStream, (OutputStream)logOutputStream));
        ExecuteWatchdog watchdog = ExecuteWatchdog.builder().setTimeout(ExecuteWatchdog.INFINITE_TIMEOUT_DURATION).get();
        this.executor.setWatchdog(watchdog);
    }

    @Override
    public void runWriteFile() throws ExecuteException, IOException {
        this.executor.execute(this.cmdLine);
    }

    @Override
    public void abortActual() {
        ExecuteWatchdog watchdog = this.executor.getWatchdog();
        if (watchdog.isWatching()) {
            logger.warn("Destroying process");
            watchdog.destroyProcess();
        }
    }

    @Override
    protected void onCompletion() throws IOException {
    }

    @Override
    public String toString() {
        return super.toString() + " " + String.valueOf(this.cmdLine);
    }
}

