/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.stage;

import com.google.common.io.ByteSource;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import org.aksw.shellgebra.exec.stage.FileWriterTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteSourceOverPipeline
extends ByteSource {
    private static final Logger logger = LoggerFactory.getLogger(ByteSourceOverPipeline.class);
    private List<ProcessBuilder> processBuilders;
    private List<FileWriterTask> fileWriters;
    private ByteSource inputSource;

    public ByteSourceOverPipeline(List<ProcessBuilder> processBuilders, List<FileWriterTask> fileWriters, ByteSource inputSource) {
        this.processBuilders = Objects.requireNonNull(processBuilders);
        this.fileWriters = Objects.requireNonNull(fileWriters);
        this.inputSource = inputSource;
        if (processBuilders.isEmpty()) {
            throw new IllegalArgumentException("List of process builders must not be empty.");
        }
    }

    public InputStream openStream() throws IOException {
        List<Process> processes = ProcessBuilder.startPipeline(this.processBuilders);
        Process firstProcess = processes.get(0);
        Process lastProcess = processes.get(processes.size() - 1);
        Thread transferThread = null;
        for (FileWriterTask task : this.fileWriters) {
            task.start();
        }
        if (this.inputSource != null) {
            transferThread = new Thread(() -> {
                try (OutputStream dest = firstProcess.getOutputStream();){
                    try (InputStream src = this.inputSource.openStream();){
                        src.transferTo(dest);
                    }
                    dest.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            transferThread.start();
        }
        InputStream in = lastProcess.getInputStream();
        return new FilterInputStream(in){

            @Override
            public void close() throws IOException {
                super.close();
                for (FileWriterTask task : ByteSourceOverPipeline.this.fileWriters) {
                    try {
                        task.close();
                    }
                    catch (Throwable t) {
                        logger.warn("Error trying to close " + String.valueOf(task), t);
                    }
                }
            }
        };
    }
}

