/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.graph;

import org.aksw.shellgebra.exec.graph.FileDescriptionImpl;
import org.aksw.shellgebra.exec.graph.ReferenceCountedObject;

public interface FileDescription<T>
extends AutoCloseable {
    public boolean isOpen();

    public T getRaw();

    public T get();

    public FileDescription<T> dup();

    @Override
    public void close();

    default public FileDescription<T> checkedDup() {
        FileDescription<T> result = this.dup();
        if (!result.isOpen()) {
            throw new IllegalStateException("Resource already closed: " + String.valueOf(this.getRaw()));
        }
        return result;
    }

    public static <T extends AutoCloseable> FileDescription<T> auto(T obj) {
        ReferenceCountedObject<T> resource = ReferenceCountedObject.of(obj);
        return FileDescription.of(resource);
    }

    public static <T> FileDescription<T> of(ReferenceCountedObject<T> resource) {
        return new FileDescriptionImpl<T>(resource);
    }
}

