/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.aksw.shellgebra.exec.SysRuntime;
import org.aksw.shellgebra.exec.SysRuntimeWrapperBase;
import org.aksw.shellgebra.exec.shell.ShellEnv;
import org.apache.commons.exec.ExecuteException;

public class SysRuntimeWrapperShellEnv
extends SysRuntimeWrapperBase<SysRuntime> {
    private ShellEnv shellEnv;
    private static final Pattern localNamePattern = Pattern.compile("^(?:(?:[^/]|//)*)$");

    public SysRuntimeWrapperShellEnv(SysRuntime delegate, ShellEnv shellEnv) {
        super(delegate);
        this.shellEnv = Objects.requireNonNull(shellEnv);
    }

    protected boolean isLocalName(String name) {
        return localNamePattern.matcher(name).matches();
    }

    public static void main(String[] args) {
        String[] tests;
        Pattern p = Pattern.compile("^(?:(?:[^/]|//)*)$");
        for (String s : tests = new String[]{"abc", "a//b", "////", "/", "a/b", "///"}) {
            System.out.printf("%-6s \u2192 %s%n", s, p.matcher(s).matches());
        }
    }

    protected String whichOrNull(String cmdName) throws IOException, InterruptedException {
        String result;
        try {
            result = super.which(cmdName);
        }
        catch (ExecuteException e) {
            if (e.getExitValue() != 1) {
                throw new ExecuteException(e.getMessage(), e.getExitValue(), (Throwable)e);
            }
            result = null;
        }
        return result;
    }

    @Override
    public String which(String cmdName) throws IOException, InterruptedException {
        String result = this.whichOrNull(cmdName);
        if (result == null && this.isLocalName(cmdName)) {
            List<String> pathStrs = this.shellEnv.streamPathCandidates(cmdName).toList();
            for (String pathStr : pathStrs) {
                Path path = Path.of(pathStr, new String[0]).toAbsolutePath();
                if (!Files.exists(path, new LinkOption[0])) continue;
                result = path.toString();
                break;
            }
        }
        if (result == null) {
            throw new ExecuteException("Process exited with non-zero code: 1", 1);
        }
        return result;
    }
}

