/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.cmd.transformer;

import java.util.ArrayList;
import java.util.List;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArg;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpExec;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpGroup;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpPipeline;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVar;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVisitor;
import org.aksw.shellgebra.algebra.cmd.transformer.CmdArgTransform;
import org.aksw.shellgebra.algebra.cmd.transformer.CmdArgTransformer;
import org.aksw.shellgebra.algebra.cmd.transformer.CmdOpTransform;
import org.aksw.shellgebra.algebra.cmd.transformer.TokenTransform;

public class CmdOpVisitorApplyTransform
implements CmdOpVisitor<CmdOp> {
    protected CmdOpTransform cmdOpTransform;
    protected CmdArgTransform cmdArgTransform;
    protected TokenTransform tokenTransform;

    public CmdOpVisitorApplyTransform(CmdOpTransform cmdOpTransform, CmdArgTransform cmdArgTransform, TokenTransform tokenTransform) {
        this.cmdOpTransform = cmdOpTransform;
        this.cmdArgTransform = cmdArgTransform;
        this.tokenTransform = tokenTransform;
    }

    public static List<CmdOp> transformAll(CmdOpVisitor<? extends CmdOp> transform, List<? extends CmdOp> subOps) {
        ArrayList<CmdOp> newOps = new ArrayList<CmdOp>(subOps.size());
        for (CmdOp cmdOp : subOps) {
            CmdOp newOp = cmdOp.accept(transform);
            newOps.add(newOp);
        }
        return newOps;
    }

    @Override
    public CmdOp visit(CmdOpExec op) {
        List<CmdArg> inArgs = op.args().args();
        ArrayList<CmdArg> outArgs = new ArrayList<CmdArg>(inArgs.size());
        for (CmdArg inArg : inArgs) {
            CmdArg outArg = CmdArgTransformer.transform(inArg, this.cmdArgTransform, this.cmdOpTransform, this.tokenTransform);
            outArgs.add(outArg);
        }
        CmdOp result = this.cmdOpTransform.transform(op, outArgs);
        return result;
    }

    @Override
    public CmdOp visit(CmdOpPipeline op) {
        List<CmdOp> newOps = op.subOps().stream().map(subOp -> subOp.accept(this)).toList();
        CmdOpPipeline result = new CmdOpPipeline(newOps);
        return result;
    }

    @Override
    public CmdOp visit(CmdOpGroup op) {
        List<CmdOp> newOps = op.subOps().stream().map(subOp -> subOp.accept(this)).toList();
        CmdOpGroup result = new CmdOpGroup(newOps);
        return result;
    }

    @Override
    public CmdOp visit(CmdOpVar op) {
        CmdOp result = this.cmdOpTransform.transform(op);
        return result;
    }
}

