/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.cmd.transform;

import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Volume;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.utils.trie.ShortNameMgr;
import org.apache.commons.io.FileUtils;

public class FileMapper {
    private List<Bind> binds;
    private String containerSharedPath;
    private ShortNameMgr shortNameMgr;

    public FileMapper clone() {
        return new FileMapper(this.containerSharedPath, this.shortNameMgr.clone(), new ArrayList<Bind>(this.binds));
    }

    public static FileMapper of(String containerSharedPath) {
        return new FileMapper(containerSharedPath);
    }

    protected FileMapper(String containerSharedPath) {
        this(containerSharedPath, new ShortNameMgr());
    }

    public FileMapper(String containerSharedPath, ShortNameMgr shortNameMgr) {
        this(containerSharedPath, shortNameMgr, new ArrayList<Bind>());
    }

    protected void addBindChecked(Bind bind) {
        String key = bind.getPath();
        Bind priorEntry = this.binds.stream().filter(b -> b.getPath().equals(key) || b.getVolume().getPath().equals(bind.getVolume().getPath())).findFirst().orElse(null);
        if (priorEntry != null) {
            throw new RuntimeException("Duplicate mount point: " + String.valueOf(bind) + " prior entry: " + String.valueOf(bind));
        }
        this.binds.add(bind);
    }

    public FileMapper(String containerSharedPath, ShortNameMgr shortNameMgr, List<Bind> binds) {
        this.containerSharedPath = Objects.requireNonNull(containerSharedPath);
        this.shortNameMgr = Objects.requireNonNull(shortNameMgr);
        this.containerSharedPath = this.containerSharedPath.replaceAll("/+$", "");
        this.binds = binds;
    }

    public List<Bind> getBinds() {
        return this.binds;
    }

    public String getContainerPath(String hostPath) {
        String result = this.getBinds().stream().filter(b -> b.getPath().equals(hostPath)).map(Bind::getVolume).map(Volume::getPath).findFirst().orElse(null);
        return result;
    }

    public String allocate(String hostPath, AccessMode accessMode) {
        String containerLocalName = this.shortNameMgr.allocate(hostPath).localName();
        String containerFullPath = this.containerSharedPath + "/" + containerLocalName;
        Bind bind = new Bind(hostPath, new Volume(containerFullPath), accessMode);
        this.addBindChecked(bind);
        return containerFullPath;
    }

    public static String allocateTempFilename(String prefix, String suffix) {
        String name = Stream.of(prefix, Long.toString(System.nanoTime()), suffix).filter(str -> !str.isEmpty()).collect(Collectors.joining("-"));
        return name;
    }

    public static Path allocateTempPath(String prefix, String suffix) {
        String name = FileMapper.allocateTempFilename(prefix, suffix);
        Path tmpDir = FileUtils.getTempDirectory().toPath();
        Path tmpFile = tmpDir.resolve(name);
        return tmpFile;
    }

    public Map.Entry<Path, String> allocateTempFile(String prefix, String suffix, AccessMode accessMode) {
        Path tmpFile = FileMapper.allocateTempPath(prefix, suffix);
        String tmpFileStr = tmpFile.toAbsolutePath().toString();
        String containerPath = this.allocate(tmpFileStr, accessMode);
        return Map.entry(tmpFile, containerPath);
    }
}

