/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.cmd.op;

import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.RedirectTarget;
import org.aksw.shellgebra.algebra.cmd.op.RedirectTargetVisitor;
import org.aksw.shellgebra.algebra.cmd.transform.RedirectTargetVisitorToString;
import org.aksw.shellgebra.exec.CmdStrOps;

public record CmdRedirect(int fd, OpenMode openMode, RedirectTarget target) {
    public static CmdRedirect in(CmdOp cmdOp) {
        return new CmdRedirect(0, OpenMode.READ, new RedirectTarget.RedirectTargetProcessSubstitution(cmdOp));
    }

    public static CmdRedirect in(String fileName) {
        return new CmdRedirect(0, OpenMode.READ, new RedirectTarget.RedirectTargetFile(fileName));
    }

    public static CmdRedirect out(String fileName) {
        return new CmdRedirect(1, OpenMode.WRITE_TRUNCATE, new RedirectTarget.RedirectTargetFile(fileName));
    }

    public static CmdRedirect err(String fileName) {
        return new CmdRedirect(2, OpenMode.WRITE_TRUNCATE, new RedirectTarget.RedirectTargetFile(fileName));
    }

    public String toString(RedirectTargetVisitor<String> visitor) {
        String arg = this.target.accept(visitor);
        String result = switch (this.openMode.ordinal()) {
            case 0 -> CmdRedirect.fdStr(this.fd, 0) + "<" + arg;
            case 1 -> CmdRedirect.fdStr(this.fd, 1) + ">" + arg;
            case 2 -> CmdRedirect.fdStr(this.fd, 1) + ">>" + arg;
            case 4 -> CmdRedirect.fdStr(this.fd, 1) + ">|" + arg;
            case 3 -> CmdRedirect.fdStr(this.fd, 1) + "<>" + arg;
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)this.openMode));
        };
        return result;
    }

    private static String fdStr(int requestedFd, int implicitFd) {
        return requestedFd == implicitFd ? "" : Integer.toString(requestedFd);
    }

    public static String toString(CmdStrOps strOps, CmdRedirect redirect) {
        RedirectTargetVisitorToString visitor = new RedirectTargetVisitorToString(strOps);
        String result = redirect.toString(visitor);
        return result;
    }

    public static enum OpenMode {
        READ,
        WRITE_TRUNCATE,
        WRITE_APPEND,
        READ_WRITE,
        CLOBBER;

    }
}

