/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.cmd.op;

import java.util.Arrays;
import java.util.List;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArg;
import org.aksw.shellgebra.algebra.cmd.arg.CmdPrefix;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVisitor;
import org.aksw.shellgebra.shim.core.ArgumentList;

public record CmdOpExec(List<CmdPrefix> prefixes, String name, ArgumentList args) implements CmdOp
{
    public CmdOpExec(String name, CmdArg ... args) {
        this(List.of(), name, ArgumentList.of(args));
    }

    public CmdOpExec(String name, ArgumentList args) {
        this(List.of(), name, args);
    }

    public CmdOpExec(List<CmdPrefix> prefixes, String name, ArgumentList args) {
        this.prefixes = List.copyOf(prefixes);
        this.name = name;
        this.args = args;
    }

    public static CmdOpExec of(String name, CmdArg ... args) {
        return CmdOpExec.of(name, List.of(args));
    }

    public static CmdOpExec of(String name, List<CmdArg> args) {
        return new CmdOpExec(List.of(), name, ArgumentList.of(args));
    }

    public static CmdOpExec ofLiteralArgs(String ... argv) {
        return CmdOpExec.ofLiteralArgs(List.of(argv));
    }

    public static CmdOpExec ofLiteralArgs(List<String> argv) {
        return CmdOpExec.ofLiterals(argv.get(0), argv.subList(1, argv.size()));
    }

    public static CmdOpExec assign(String key, String value) {
        return new CmdOpExec(List.of(new CmdPrefix(key, value)), null, ArgumentList.of(new CmdArg[0]));
    }

    public static CmdOpExec ofLiterals(String name, String ... args) {
        return CmdOpExec.ofLiterals(name, Arrays.asList(args));
    }

    public static CmdOpExec ofLiterals(String name, List<String> args) {
        return new CmdOpExec(List.of(), name, ArgumentList.of(args.stream().map(CmdArg::ofLiteral).toList()));
    }

    public String getName() {
        return this.name;
    }

    @Override
    public <T> T accept(CmdOpVisitor<T> visitor) {
        T result = visitor.visit(this);
        return result;
    }

    @Override
    public String toString() {
        return "(exec (" + this.getName() + (this.args.size() == 0 ? "" : " ") + CmdOp.toStrings(this.args) + "))";
    }
}

