/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.cmd.arg;

import java.util.List;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArg;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgCmdOp;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgRedirect;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgVisitor;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgWord;
import org.aksw.shellgebra.algebra.cmd.arg.Token;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVisitor;
import org.aksw.shellgebra.algebra.cmd.op.CmdRedirect;
import org.aksw.shellgebra.algebra.cmd.transform.CmdOpVisitorToCmdString;
import org.aksw.shellgebra.algebra.cmd.transform.CmdString;
import org.aksw.shellgebra.exec.CmdStrOps;
import org.aksw.shellgebra.exec.CmdStrOpsBash;

public class CmdArgVisitorRenderAsBashString
implements CmdArgVisitor<String> {
    private CmdStrOps strOps;
    private CmdOpVisitor<CmdString> cmdOpVisitorToString;

    public CmdArgVisitorRenderAsBashString(CmdOpVisitor<CmdString> cmdOpVisitorToString, CmdStrOps strOps) {
        this.cmdOpVisitorToString = cmdOpVisitorToString;
        this.strOps = strOps;
    }

    public static List<String> render(List<CmdArg> args) {
        CmdStrOps strOps = CmdStrOpsBash.get();
        return CmdArgVisitorRenderAsBashString.render(new CmdOpVisitorToCmdString(strOps), strOps, args);
    }

    public static List<String> render(CmdOpVisitor<CmdString> cmdOpVisitorToString, CmdStrOps strOps, List<CmdArg> args) {
        CmdArgVisitorRenderAsBashString renderer = new CmdArgVisitorRenderAsBashString(cmdOpVisitorToString, strOps);
        List<String> result = args.stream().map(arg -> (String)arg.accept(renderer)).toList();
        return result;
    }

    @Override
    public String visit(CmdArgWord arg) {
        TokenVisitorRenderToString renderer = new TokenVisitorRenderToString();
        StringBuilder sb = new StringBuilder();
        for (Token token : arg.tokens()) {
            String contrib = token.accept(renderer);
            sb.append(contrib);
        }
        String result = sb.toString();
        return result;
    }

    @Override
    public String visit(CmdArgCmdOp arg) {
        CmdOp cmdOp = arg.cmdOp();
        String subStr = CmdOpVisitorToCmdString.toArg(cmdOp.accept(this.cmdOpVisitorToString));
        String result = this.strOps.processSubstitution(subStr);
        return result;
    }

    @Override
    public String visit(CmdArgRedirect arg) {
        CmdRedirect redirect = arg.redirect();
        String result = CmdRedirect.toString(this.strOps, redirect);
        return result;
    }

    public class TokenVisitorRenderToString
    implements Token.TokenVisitor<String> {
        @Override
        public String visit(Token.TokenLiteral token) {
            return token.value();
        }

        @Override
        public String visit(Token.TokenPath token) {
            return token.path();
        }

        @Override
        public String visit(Token.TokenVar token) {
            return "$(" + token.name() + ")";
        }

        @Override
        public String visit(Token.TokenCmdOp token) {
            CmdOp cmdOp = token.cmdOp();
            CmdString cmdString = cmdOp.accept(CmdArgVisitorRenderAsBashString.this.cmdOpVisitorToString);
            String result = CmdOpVisitorToCmdString.toArg(cmdString);
            return result;
        }
    }
}

