/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.cmd.arg;

import org.aksw.shellgebra.algebra.cmd.arg.CmdArgCmdOp;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgRedirect;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgVisitor;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgWord;
import org.aksw.shellgebra.algebra.cmd.arg.StringEscapeType;
import org.aksw.shellgebra.algebra.cmd.arg.Token;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdRedirect;

public interface CmdArg {
    public <T> T accept(CmdArgVisitor<T> var1);

    public static CmdArg redirect(CmdRedirect redirect) {
        return new CmdArgRedirect(redirect);
    }

    public static CmdArg ofLiteral(String str) {
        return new CmdArgWord(StringEscapeType.ESCAPED, new Token.TokenLiteral(str));
    }

    public static CmdArg ofString(String str) {
        return new CmdArgWord(StringEscapeType.SINGLE_QUOTED, new Token.TokenLiteral(str));
    }

    public static CmdArg ofPathString(String pathStr) {
        return new CmdArgWord(StringEscapeType.SINGLE_QUOTED, new Token.TokenPath(pathStr));
    }

    public static CmdArg ofVarName(String varName) {
        return new CmdArgWord(StringEscapeType.SINGLE_QUOTED, new Token.TokenVar(varName));
    }

    public static CmdArg ofCommandSubstitution(CmdOp cmdOp) {
        return new CmdArgWord(StringEscapeType.SINGLE_QUOTED, new Token.TokenCmdOp(cmdOp));
    }

    public static CmdArg ofProcessSubstution(CmdOp cmdOp) {
        return new CmdArgCmdOp(cmdOp);
    }
}

