/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.docker;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.aksw.shellgebra.util.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostNameUtils {
    private static final Logger logger = LoggerFactory.getLogger(HostNameUtils.class);

    public static String getHostName() {
        String result = HostNameUtils.getHostNameByHostNameCommand();
        if (result == null && (result = HostNameUtils.getHostNameByEtcHostNameFile()) == null && (result = HostNameUtils.getHostNameByMxBean()) == null) {
            result = HostNameUtils.getHostNameByInet();
        }
        return result;
    }

    public static String getHostNameByHostNameCommand() {
        return HostNameUtils.getOrNull(() -> Optional.ofNullable(SystemUtils.getCommandOutput("hostname")).map(String::trim).orElse(null));
    }

    public static String getHostNameByEtcHostNameFile() {
        Path file = Path.of("/etc/hostname", new String[0]);
        String result = HostNameUtils.getOrNull(() -> Files.exists(file, new LinkOption[0]) ? Files.readString(file).trim() : null);
        return result;
    }

    public static String getHostNameByMxBean() {
        return ManagementFactory.getRuntimeMXBean().getName().replaceAll("^[^@]*@", "");
    }

    public static String getHostNameByInet() {
        String result;
        try {
            result = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            logger.debug("Could not resolve localhost ", (Throwable)e);
            result = null;
        }
        return result;
    }

    protected static <T> T getOrNull(Callable<T> callable) {
        T result;
        try {
            result = callable.call();
        }
        catch (Exception e) {
            logger.info("Execution error", (Throwable)e);
            result = null;
        }
        return result;
    }
}

