package org.aksw.shellgebra.exec.stage;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;

import com.google.common.io.ByteSource;

import org.aksw.commons.io.util.stream.InputStreamTransform;
import org.aksw.shellgebra.exec.TransformedByteSource;

public class StageJvm
    implements Stage
{
    private InputStreamTransform transform;

    public StageJvm(InputStreamTransform transform) {
        super();
        this.transform = Objects.requireNonNull(transform);
    }

    @Override
    public BoundStage from(ByteSource input) {
        return new BoundStageJvm(input, transform);
    }

    @Override
    public BoundStage from(FileWriterTask input) {
        // TODO Protect against multiple starts of the same input!
        ByteSource bs = new ByteSource() {
            @Override
            public InputStream openStream() throws IOException {
                Path path = input.getOutputPath();
                input.start();
                InputStream in = Files.newInputStream(path);
                InputStream result = new FilterInputStream(in) {
                    @Override
                    public void close() throws IOException {
                        try {
                            input.close();
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        } finally {
                            super.close();
                        }
                    }
                };
                return result;
            }
        };
        return new BoundStageJvm(bs, transform);
    }

    @Override
    public BoundStage from(BoundStage input) {
        ByteSource rawByteSource = input.toByteSource();
        ByteSource byteSource = TransformedByteSource.transform(rawByteSource, transform);
        return new BoundStageByteSource(byteSource);
    }

    @Override
    public BoundStage fromNull() {
        return from(ByteSource.empty());
    }

    @Override
    public String toString() {
        return "(jvmStage " +  transform.toString() + ")";
    }
}
