package org.aksw.shellgebra.exec.site;

import java.util.List;

import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpGroup;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpPipeline;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVar;
import org.aksw.shellgebra.algebra.cmd.op.placed.PlacedCmdOp.PlacedCmd;
import org.aksw.shellgebra.algebra.cmd.transformer.CmdOpTransformBase;
import org.aksw.shellgebra.exec.model.ExecSite;
import org.aksw.shellgebra.exec.model.ExecSiteCurrentHost;
import org.aksw.shellgebra.exec.model.ExecSiteCurrentJvm;
import org.aksw.shellgebra.exec.model.ExecSiteDockerImage;
import org.aksw.shellgebra.exec.model.ExecSiteVisitor;
import org.aksw.shellgebra.exec.stage.Stage;
import org.aksw.vshell.registry.FinalPlacement;

// superInput | { x | { y ; VAR } }
class CmdOpTransformStageGenerator2
    implements CmdOpTransformBase
{
    private Stage inputStage;

    @Override
    public CmdOp transform(CmdOpGroup op, List<CmdOp> subOps) {
        // If there is a var in the group then
        // (1) the current input must be passed on to a named pipe and
        // (2) that named pipe must be passed to all members of the group.
        // The var gets substituted for 'cat named-pipe'.

        boolean hasVars = subOps.stream().anyMatch(subOp -> subOp instanceof CmdOpVar);

        if (!hasVars) {
            // Easy case: return as is.
            return CmdOpTransformBase.super.transform(op, subOps);
        } else {
            // Hard case: turn the
        }
        return null;
    }

    @Override
    public CmdOp transform(CmdOpPipeline op, List<CmdOp> subOps) {
        // TODO Auto-generated method stub
        return CmdOpTransformBase.super.transform(op, subOps);
    }

    @Override
    public CmdOp transform(CmdOpVar op) {
        // TODO Auto-generated method stub
        return CmdOpTransformBase.super.transform(op);
    }

    public CmdOp process(CmdOp op) {
        CmdOp result = op instanceof CmdOpVar
            ? processVar(op)
            : op.accept(null); // TODO
        return result;
    }

    public CmdOp processVar(CmdOp opVar) {
        FinalPlacement placements = null;
        PlacedCmd placedCmd = placements.placements().get(opVar);

        ExecSite execSite = placedCmd.execSite();
        CmdOp subCmd = placedCmd.cmdOp();

        // If the sub op is host or docker: create input / output pipes and wire up the containers.
        // If the sub op is jvm: delegate to the jvm handler that injects procCtl+echo procOut statements.
        //   (for docker containers, procCtl must be bind mounted)

        CmdOp result = execSite.accept(new ExecSiteVisitor<CmdOp>() {
            @Override
            public CmdOp visit(ExecSiteDockerImage execSite) {
                throw new UnsupportedOperationException();
            }

            @Override
            public CmdOp visit(ExecSiteCurrentHost execSite) {
                throw new UnsupportedOperationException();
            }

            @Override
            public CmdOp visit(ExecSiteCurrentJvm execSite) {
                throw new UnsupportedOperationException();
            }
        });

        return result;
    }
}
