/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Objects;
import org.aksw.vshell.registry.Output;

public abstract class OutputBase
implements Output {
    private OutputStream outputStream;
    private PrintStream printer;
    private BufferedWriter writer = null;
    private Charset writerCharset = null;

    protected OutputBase(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    protected abstract OutputStream openOutputStream() throws IOException;

    @Override
    public Charset getWriterCharset() {
        return this.writerCharset;
    }

    @Override
    public boolean hasWriter() {
        return this.writer != null;
    }

    @Override
    public boolean hasPrinter() {
        return this.printer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream outputStream() {
        OutputBase outputBase = this;
        synchronized (outputBase) {
            if (this.outputStream == null) {
                try {
                    this.outputStream = this.openOutputStream();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.outputStream;
    }

    @Override
    public final PrintStream printStream() {
        return this.printStream(Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final PrintStream printStream(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        OutputBase outputBase = this;
        synchronized (outputBase) {
            if (this.printer == null) {
                if (this.writer != null) {
                    throw new IllegalStateException("Cannot create PrintStream because a BufferedWriter was already created with charset: " + String.valueOf(this.writerCharset));
                }
                this.writerCharset = charset;
                this.printer = new PrintStream(this.outputStream(), true, charset);
            } else if (!this.writerCharset.equals(charset)) {
                throw new IllegalStateException("BufferedWriter was created with charset: " + String.valueOf(this.writerCharset));
            }
            return this.printer;
        }
    }

    @Override
    public final BufferedWriter writer() {
        return this.writer(Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final BufferedWriter writer(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        OutputBase outputBase = this;
        synchronized (outputBase) {
            if (this.writer == null) {
                if (this.printer != null) {
                    throw new IllegalStateException("Cannot create BufferedWriter because a PrintStream was already created with charset: " + String.valueOf(this.writerCharset));
                }
                this.writerCharset = charset;
                this.writer = new BufferedWriter(new OutputStreamWriter(this.outputStream(), charset));
            } else if (!this.writerCharset.equals(charset)) {
                throw new IllegalStateException("BufferedWriter was created with charset: " + String.valueOf(this.writerCharset));
            }
            return this.writer;
        }
    }

    @Override
    public final void flush() throws IOException {
        if (this.printer != null) {
            this.printer.flush();
        } else if (this.writer != null) {
            this.writer.flush();
        } else if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.printer != null) {
            this.printer.close();
        } else if (this.writer != null) {
            this.writer.close();
        } else if (this.outputStream != null) {
            this.outputStream.close();
        }
    }
}

