/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArg;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpExec;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVar;
import org.aksw.shellgebra.algebra.cmd.op.CmdOps;
import org.aksw.shellgebra.algebra.cmd.op.placed.PlacedCmdOp;
import org.aksw.shellgebra.algebra.cmd.transformer.CmdOpTransformBase;
import org.aksw.shellgebra.algebra.cmd.transformer.CmdOpTransformer;
import org.aksw.shellgebra.exec.model.ExecSite;
import org.aksw.shellgebra.shim.core.ArgumentList;
import org.aksw.vshell.registry.CommandBinding;
import org.aksw.vshell.registry.CommandCatalog;
import org.aksw.vshell.registry.ExecSiteResolver;
import org.aksw.vshell.registry.FinalPlacement;

public class FinalPlacementResolver {
    public static FinalPlacement resolve(FinalPlacement inPlacement, ExecSiteResolver resolver, CommandCatalog inferredCatalog) {
        PlacedCmdOp.PlacedCmd root = inPlacement.cmdOp();
        Map<CmdOpVar, PlacedCmdOp.PlacedCmd> inMap = inPlacement.placements();
        FinalPlacementResolverWorker worker = new FinalPlacementResolverWorker(resolver, inferredCatalog, inMap);
        CmdOp cmdOp = root.cmdOp();
        ExecSite execSite = root.execSite();
        PlacedCmdOp.PlacedCmd tmp = worker.place(cmdOp, execSite);
        Map<CmdOpVar, PlacedCmdOp.PlacedCmd> outMap = worker.getOutMap();
        return new FinalPlacement(tmp, outMap);
    }

    public static CmdOp resolve(CmdOp cmdOp, final ExecSite execSite, final ExecSiteResolver resolver, final CommandCatalog inferredCatalog) {
        CmdOpTransformBase transform = new CmdOpTransformBase(){

            @Override
            public CmdOp transform(CmdOpExec op, List<CmdArg> subOps) {
                String outName;
                String inName = op.name();
                boolean doResolve = false;
                if (doResolve) {
                    CommandBinding outCmdBinding = inferredCatalog.get(inName, execSite).map(s -> (CommandBinding)s.iterator().next()).orElse(null);
                    if (outCmdBinding == null) {
                        outCmdBinding = resolver.resolve(inName, execSite).orElseThrow(() -> new RuntimeException("Should not happen - could not resolve: " + inName + " on site " + String.valueOf(execSite)));
                    }
                    outName = outCmdBinding.commandName();
                } else {
                    outName = inName;
                }
                return new CmdOpExec(op.prefixes(), outName, ArgumentList.of(subOps));
            }
        };
        CmdOp result = CmdOpTransformer.transform(cmdOp, transform, null, null);
        return result;
    }

    static class FinalPlacementResolverWorker {
        private Map<CmdOpVar, PlacedCmdOp.PlacedCmd> inMap;
        private Map<CmdOpVar, PlacedCmdOp.PlacedCmd> outMap = new HashMap<CmdOpVar, PlacedCmdOp.PlacedCmd>();
        private ExecSiteResolver resolver;
        private CommandCatalog inferredCatalog;

        public FinalPlacementResolverWorker(ExecSiteResolver resolver, CommandCatalog inferredCatalog, Map<CmdOpVar, PlacedCmdOp.PlacedCmd> inMap) {
            this.resolver = resolver;
            this.inferredCatalog = inferredCatalog;
            this.inMap = inMap;
        }

        public Map<CmdOpVar, PlacedCmdOp.PlacedCmd> getOutMap() {
            return this.outMap;
        }

        public PlacedCmdOp.PlacedCmd place(CmdOp inParentOp, ExecSite parentSite) {
            CmdOp outParentOp = FinalPlacementResolver.resolve(inParentOp, parentSite, this.resolver, this.inferredCatalog);
            Set<CmdOpVar> parentVars = CmdOps.accVars(inParentOp);
            HashMap<CmdOpVar, CmdOp> substMap = new HashMap<CmdOpVar, CmdOp>();
            for (CmdOpVar v : parentVars) {
                PlacedCmdOp.PlacedCmd inChild = this.inMap.get(v);
                CmdOp inChildCmdOp = inChild.cmdOp();
                ExecSite inChildExecSite = inChild.execSite();
                PlacedCmdOp.PlacedCmd outChild = this.place(inChildCmdOp, inChildExecSite);
                CmdOp outChildOp = outChild.cmdOp();
                ExecSite outChildExecSite = outChild.execSite();
                if (outChildExecSite.equals(parentSite)) {
                    substMap.put(v, outChildOp);
                    continue;
                }
                PlacedCmdOp.PlacedCmd childPlacement = this.place(outChildOp, outChildExecSite);
                this.outMap.put(v, childPlacement);
            }
            return new PlacedCmdOp.PlacedCmd(outParentOp, parentSite);
        }
    }
}

